/*
 * Decompiled with CFR 0.152.
 */
package fenchel.measurefacto;

import fenchel.measurefacto.PointwiseOperation;
import fenchel.measurefacto.PointwiseOperationApplicator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import nuts.io.IO;

public final class ComputeXis
implements PointwiseOperation {
    public static double LARGE_VALUE = 1.0E50;
    private final double[] alphas;

    public static <M> void computeXis(PointwiseOperationApplicator<M> applicator, List<M> zetas, M parameter, List<Double> alphas) {
        ArrayList<M> mainArguments = new ArrayList<M>(zetas.size() + 1);
        mainArguments.addAll(zetas);
        mainArguments.add(parameter);
        applicator.apply(new ComputeXis(alphas), mainArguments, Collections.EMPTY_LIST);
    }

    private ComputeXis(List<Double> alpha) {
        if (alpha == null) {
            this.alphas = null;
        } else {
            this.alphas = new double[alpha.size()];
            for (int i = 0; i < alpha.size(); ++i) {
                this.alphas[i] = alpha.get(i);
            }
        }
    }

    private double pow(double n, int idx) {
        return this.alphas == null ? n : Math.pow(n, this.alphas[idx]);
    }

    @Override
    public void apply(double[][] values, int index) {
        int i;
        int nInputs = values.length;
        int nZetas = nInputs - 1;
        int paramIndex = nInputs - 1;
        int nZeroes = 0;
        int nInf = 0;
        double product = 1.0;
        for (i = 0; i < nZetas; ++i) {
            double currentValue = values[i] == null ? 1.0 : this.pow(values[i][index], i);
            product *= currentValue;
            if (Double.isInfinite(currentValue)) {
                ++nInf;
            }
            if (currentValue != 0.0) continue;
            ++nZeroes;
        }
        if ((product *= values[paramIndex][index]) == 0.0 && nZeroes == 0) {
            IO.warnOnce("Underflow!");
        }
        if (Double.isInfinite(product) && nInf == 0) {
            IO.warnOnce("Overflow!");
        }
        if (nZeroes > 0 && nInf > 0) {
            IO.warnOnce("PotentialInconsistency(nZeroes=" + nZeroes + ",nInf=" + nInf + ")");
        }
        if (Double.isNaN(product)) {
            IO.warnOnce("InconsistencyDetected(nZeroes=" + nZeroes + ",nInf=" + nInf + "). Reverting a coordinate to its initial parameter value");
            for (i = 0; i < nZetas; ++i) {
                if (values[i] == null) continue;
                values[i][index] = values[paramIndex][index];
            }
        } else {
            for (i = 0; i < nZetas; ++i) {
                if (values[i] == null) continue;
                values[i][index] = product == 0.0 ? 0.0 : (Double.isInfinite(product) ? LARGE_VALUE : product / this.pow(values[i][index], i));
            }
        }
    }
}

