/*
 * Decompiled with CFR 0.152.
 */
package fig.exec.servlet;

import fig.basic.CharEncUtils;
import fig.basic.Pair;
import fig.basic.Utils;
import fig.exec.servlet.ArgumentException;
import fig.exec.servlet.Authenticator;
import fig.exec.servlet.Item;
import fig.exec.servlet.MyException;
import fig.exec.servlet.OperationRP;
import fig.exec.servlet.Permissions;
import fig.exec.servlet.ResponseObject;
import fig.exec.servlet.ResponseParams;
import fig.exec.servlet.RootView;
import fig.exec.servlet.UpdateQueue;
import fig.exec.servlet.UpdateSpec;
import fig.exec.servlet.WebState;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ExecsServlet
extends HttpServlet {
    private static final long serialVersionUID = 42L;
    private String prependFile;
    private String domainsDir;
    private RootView rootView;
    private Authenticator authenticator;
    private UpdaterThread updaterThread;

    protected String getTitle() {
        return "Executions";
    }

    public void init() {
        String propertiesFile = this.getServletName() + ".properties";
        ServletContext context = this.getServletContext();
        Properties properties = Utils.loadProperties(context.getRealPath(propertiesFile));
        CharEncUtils.setCharEncoding(properties.getProperty("encoding"));
        this.prependFile = context.getRealPath(properties.getProperty("prependFile"));
        this.domainsDir = properties.getProperty("domainsDir");
        this.rootView = new RootView(context.getRealPath(this.domainsDir));
        this.authenticator = new Authenticator(this.rootView);
        WebState.setServlet(this);
        WebState.logs(this.getServletName() + ".init()");
        this.updaterThread = new UpdaterThread(this.rootView);
        this.updaterThread.start();
    }

    public void destroy() {
        WebState.logs(this.getServletName() + ".destroy()");
        this.updaterThread.terminate();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doGetPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doGetPost(request, response);
    }

    public void doGetPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        block6: {
            WebState state = new WebState(request, response);
            Permissions perm = this.authenticator.getPermissions(state.request);
            this.printInfo(state, perm);
            String mode = state.params.get("mode", "display");
            try {
                if (mode.equals("auth")) {
                    this.givePermissions(state);
                    break block6;
                }
                if (mode.equals("verbose")) {
                    this.setVerbose(state);
                    break block6;
                }
                if (mode.equals("op")) {
                    this.handleOperation(state, perm);
                    break block6;
                }
                if (mode.equals("display")) {
                    this.displayStuff(state, perm);
                    break block6;
                }
                throw new MyException("Invalid mode: " + mode);
            }
            catch (MyException e) {
                new ResponseParams(e).dump(state);
            }
        }
        this.updaterThread.hit();
        WebState.logs("doGetPost(): finished");
    }

    protected void printInfo(WebState state, Permissions perm) {
        WebState.logs("Info:");
        WebState.logs("  HOST: " + state.request.getRemoteHost());
        WebState.logs("  USER: " + state.request.getUserPrincipal() + " " + state.request.getRemoteUser());
        WebState.logs("  PERM: " + perm);
        WebState.logs("  QUERY: " + state.request.getQueryString());
        state.params.dumpToLog();
    }

    private void givePermissions(WebState state) throws MyException, IOException {
        String auth = (String)state.params.get("auth");
        if (auth == null) {
            throw new ArgumentException("No authentication string specified");
        }
        boolean ok = this.authenticator.givePermissions(auth, state.response);
        new ResponseParams(ok, "Authenticated", "Invalid authentication").dump(state);
    }

    private void setVerbose(WebState state) throws MyException, IOException {
        boolean verbose = state.getVerbose();
        verbose = !verbose;
        state.setVerbose(verbose);
        new ResponseParams("verbose is now " + verbose).dump(state);
    }

    private void handleOperation(WebState state, Permissions perm, OperationRP req, Item item) throws MyException, IOException {
        ResponseObject resp = item.handleOperation(req, perm);
        resp.dump(state);
    }

    private void handleOperation(WebState state, Permissions perm, OperationRP req) throws MyException, IOException {
        Item item = this.rootView.getItem(req.getTrail());
        this.handleOperation(state, perm, req, item);
    }

    private void handleOperation(WebState state, Permissions perm) throws MyException, IOException {
        OperationRP req = new OperationRP(state.params, this.updaterThread.getUpdateSpec());
        this.handleOperation(state, perm, req);
    }

    private void displayStuff(WebState state, Permissions perm) throws MyException, IOException {
        state.initOutput();
        if (new File(this.prependFile).exists()) {
            state.hw.writeFile(this.prependFile);
        }
        state.hw.begin(this.getTitle(), "onload='onLoad()' onkeypress='onKeyPress(event)'", true);
        if (state.params.containsKey("op")) {
            this.handleOperation(state, perm);
        } else {
            OperationRP req = new OperationRP(this.updaterThread.getUpdateSpec());
            req.put("name", "root");
            req.setOp("getItemsTable");
            this.handleOperation(state, perm, req, this.rootView);
        }
        state.hw.end();
        state.endOutput();
    }

    private static class UpdaterThread
    extends Thread {
        private RootView rootView;
        private UpdateSpec updateSpec;
        private int sleepInterval;
        private boolean done;
        private int initSleepInterval = 1000000000;
        private double sleepGrowthFactor = 1.2;

        public UpdaterThread(RootView rootView) {
            this.rootView = rootView;
            this.updateSpec = new UpdateSpec();
            this.done = false;
            this.sleepInterval = this.initSleepInterval;
        }

        public void update() {
            UpdateQueue queue = this.updateSpec.getQueue();
            try {
                Pair<Item, UpdateQueue.Priority> pair;
                WebState.logs("UpdaterThread.update(): " + queue);
                while ((pair = queue.dequeue()) != null) {
                    pair.getFirst().update(this.updateSpec, pair.getSecond());
                }
                WebState.logs("UpdaterThread.update(): finished");
            }
            catch (MyException e) {
                WebState.logs("UpdaterThread.update() failed: " + Utils.getStackTrace(e));
            }
        }

        @Override
        public void run() {
            WebState.logs("UpdaterThread.run(): begin");
            while (!this.done) {
                this.update();
                Utils.sleep(this.sleepInterval);
                this.sleepInterval = (int)((double)this.sleepInterval * this.sleepGrowthFactor);
            }
            WebState.logs("UpdaterThread.run(): done");
        }

        public void terminate() {
            this.done = true;
        }

        public void hit() {
            this.sleepInterval = this.initSleepInterval;
            this.interrupt();
        }

        public UpdateSpec getUpdateSpec() {
            return this.updateSpec;
        }
    }
}

