/*
 * Decompiled with CFR 0.152.
 */
package fig.exec.servlet;

import fig.basic.IOUtils;
import fig.basic.Utils;
import fig.exec.servlet.Field;
import fig.exec.servlet.FieldListMap;
import fig.exec.servlet.FileSource;
import fig.exec.servlet.MapFileItem;
import fig.exec.servlet.MyException;
import fig.exec.servlet.Trail;
import fig.exec.servlet.Value;
import fig.exec.servlet.WebState;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class IndexFileItem
extends MapFileItem {
    private List<String> list = new ArrayList<String>();

    public IndexFileItem(Trail trail, FileSource source) {
        super(trail, source);
    }

    @Override
    protected Value getFieldValue(String name) throws MyException {
        if (name.equals("Count")) {
            return new Value(this.list.size());
        }
        return super.getFieldValue(name);
    }

    @Override
    public FieldListMap getMetadataFields() {
        FieldListMap fields = super.getMetadataFields();
        fields.add(new Field("Count", "Number of things in the list"));
        return fields;
    }

    @Override
    public void load() throws MyException {
        try {
            BufferedReader r = IOUtils.openIn(this.source.getPath());
            int n = Integer.parseInt(r.readLine());
            this.list = new ArrayList<String>(n);
            for (int i = 0; i < n; ++i) {
                this.list.add(r.readLine());
            }
            this.map.read(r);
            r.close();
        }
        catch (IOException e) {
            WebState.logs("IndexFileItem: loading " + this.trail + " failed: IOException");
        }
        catch (NumberFormatException e) {
            WebState.logs("IndexFileItem: loading " + this.trail + " failed: NumberFormatException");
        }
    }

    @Override
    public void save() throws MyException {
        try {
            PrintWriter w = IOUtils.openOut(this.source.getPath());
            w.println(this.list.size());
            for (String x : this.list) {
                w.println(x);
            }
            this.map.print(w);
            w.close();
        }
        catch (IOException e) {
            WebState.logs(Utils.getStackTrace((Throwable)e, 5));
        }
    }

    public void addToList(String x) throws MyException {
        this.list.add(x);
    }

    public List<String> getList() {
        return this.list;
    }

    public void setList(List<String> list) {
        this.list = list;
    }
}

