/*
 * Decompiled with CFR 0.152.
 */
package fig.prob;

import fig.prob.SuffStats;

public class BinomialSuffStats
implements SuffStats {
    private double trueCount;
    private double falseCount;

    public BinomialSuffStats() {
    }

    public BinomialSuffStats(boolean x) {
        this.trueCount = x ? 1.0 : 0.0;
        this.falseCount = x ? 0.0 : 1.0;
    }

    public BinomialSuffStats(double trueCount, double falseCount) {
        this.trueCount = trueCount;
        this.falseCount = falseCount;
    }

    @Override
    public void add(SuffStats _stats) {
        BinomialSuffStats stats = (BinomialSuffStats)_stats;
        this.trueCount += stats.trueCount;
        this.falseCount += stats.falseCount;
    }

    @Override
    public void sub(SuffStats _stats) {
        BinomialSuffStats stats = (BinomialSuffStats)_stats;
        this.trueCount -= stats.trueCount;
        this.falseCount -= stats.falseCount;
    }

    public SuffStats reweight(double scale) {
        return new BinomialSuffStats(scale * this.trueCount, scale * this.falseCount);
    }

    public double getTrueCount() {
        return this.trueCount;
    }

    public double getFalseCount() {
        return this.falseCount;
    }

    public double totalCount() {
        return this.trueCount + this.falseCount;
    }

    public String toString() {
        return String.format("+(%.3f),-(%.3f)", this.trueCount, this.falseCount);
    }
}

