/*
 * Decompiled with CFR 0.152.
 */
package fig.servlet;

import fig.basic.IOUtils;
import fig.basic.ListUtils;
import fig.basic.OrderedMap;
import fig.servlet.AllExecView;
import fig.servlet.ExecItem;
import fig.servlet.FieldListMap;
import fig.servlet.FilteredExecView;
import fig.servlet.GroundedExecView;
import fig.servlet.Item;
import fig.servlet.MyException;
import fig.servlet.SimpleFilteredExecView;
import fig.servlet.UpdateQueue;
import fig.servlet.UpdateSpec;
import java.util.HashSet;

public class ExecViewDB
extends Item {
    public final AllExecView allExecView;
    public final FilteredExecView orphanedExecView;
    public final FilteredExecView thunkExecView;
    public final FilteredExecView runningExecView;

    public ExecViewDB(Item parent, String name, String execsPath, String viewsPath) {
        super(parent, name, viewsPath);
        IOUtils.createNewDirIfNotExistsEasy(this.sourcePath);
        IOUtils.createNewFileIfNotExistsEasy(this.fileSourcePath());
        this.allExecView = new AllExecView(this, "(all)", execsPath);
        this.addItem(this.allExecView);
        this.orphanedExecView = new FilteredExecView(this, "(orphaned)", execsPath){

            @Override
            protected String getDescription() {
                return "Orphaned executions: those not in any execution view";
            }

            @Override
            protected void filterItems(OrderedMap<String, Item> newItems) {
                ExecViewDB execViewDB = this.getExecViewDB();
                AllExecView allExecView = execViewDB.allExecView;
                HashSet<Item> hitItems = new HashSet<Item>();
                for (Item execView : execViewDB.items.values()) {
                    if (!(execView instanceof GroundedExecView)) continue;
                    for (Item item : execView.items.values()) {
                        hitItems.add(item);
                    }
                }
                for (Item item : allExecView.items.values()) {
                    if (hitItems.contains(item)) continue;
                    this.addItem(newItems, item);
                }
            }
        };
        this.addItem(this.orphanedExecView);
        this.thunkExecView = new SimpleFilteredExecView(this, "(thunks)", "Thunks: executions waiting to be run"){

            @Override
            protected boolean accept(ExecItem item) {
                return item.isThunk();
            }

            @Override
            protected FieldListMap getItemsFields() {
                return ExecItem.createThunkFields();
            }
        };
        this.addItem(this.thunkExecView);
        this.runningExecView = new SimpleFilteredExecView(this, "(running)", "Running executions"){

            @Override
            protected boolean accept(ExecItem item) {
                return item.isRunning();
            }
        };
        this.addItem(this.runningExecView);
    }

    @Override
    public FieldListMap getItemsFields() {
        return new GroundedExecView(null, null, null).getMetadataFields();
    }

    @Override
    protected String getDescription() {
        return "Executions are the experiments.";
    }

    @Override
    public void update(UpdateSpec spec, UpdateQueue.Priority priority) throws MyException {
        this.updateItemsFromFile(spec, ListUtils.newList(this.allExecView), ListUtils.newList(this.orphanedExecView, this.thunkExecView, this.runningExecView));
        this.updateChildren(spec, priority.next());
    }

    @Override
    protected boolean isView() {
        return true;
    }

    @Override
    protected Item newItem(String name) {
        return new GroundedExecView(this, name, this.childNameToIndexSourcePath(name));
    }

    @Override
    protected String itemToHandle(Item item) throws MyException {
        if (item == this.allExecView || item == this.orphanedExecView || item == this.thunkExecView || item == this.runningExecView) {
            return null;
        }
        return super.itemToHandle(item);
    }
}

