/*
 * Decompiled with CFR 0.152.
 */
package fig.servlet;

import fig.basic.StrUtils;
import fig.servlet.FilenameFilterBank;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;

public class FileUtils {
    public static List<String> getChildren(String basePath, int depth, TraverseSpec spec) {
        return FileUtils.getChildren(basePath, "", depth, spec);
    }

    public static List<String> getChildren(String basePath, String dir, int depth, TraverseSpec spec) {
        ArrayList<String> childDirs = new ArrayList<String>();
        FileUtils.getChildren(basePath, childDirs, dir, depth, spec);
        return childDirs;
    }

    private static void getChildren(String basePath, List<String> childDirs, String dir, int depth, TraverseSpec spec) {
        if (depth == 0) {
            return;
        }
        String[] childNames = new File(basePath, dir).list();
        if (childNames == null) {
            return;
        }
        for (String childName : childNames) {
            String childDir;
            String string = childDir = StrUtils.isEmpty(dir) ? childName : new File(dir, childName).toString();
            if (spec.retFilter == null || spec.retFilter.accept(new File(basePath), childDir)) {
                childDirs.add(childDir);
            }
            if (!new File(basePath, childDir).isDirectory() || spec.descendFilter != null && !spec.descendFilter.accept(new File(basePath), childDir)) continue;
            FileUtils.getChildren(basePath, childDirs, childDir, depth - 1, spec);
        }
    }

    public static String getExt(String file) {
        int i = file.lastIndexOf(46);
        if (i == -1) {
            return "";
        }
        return file.substring(i + 1);
    }

    public static boolean isDirectory(String path) {
        return new File(path).isDirectory();
    }

    public static boolean isFile(String path) {
        return new File(path).isFile();
    }

    public static class TraverseSpec {
        private FilenameFilter retFilter;
        private FilenameFilter descendFilter;

        public TraverseSpec(FilenameFilter retFilter, FilenameFilter descendFilter) {
            this.retFilter = retFilter;
            this.descendFilter = descendFilter;
        }

        public static TraverseSpec allowAll() {
            return new TraverseSpec(null, null);
        }

        public static TraverseSpec allowOnlyFiles() {
            return new TraverseSpec(FilenameFilterBank.onlyFile(), null);
        }

        public static TraverseSpec matchExt(String ext) {
            return new TraverseSpec(new FilenameFilterBank.Regex(".*\\." + ext, true), null);
        }
    }
}

