/*
 * Decompiled with CFR 0.152.
 */
package fig.servlet;

import fig.basic.IOUtils;
import fig.basic.OrderedMap;
import fig.servlet.ExecItem;
import fig.servlet.FieldListMap;
import fig.servlet.Item;
import fig.servlet.MyException;
import fig.servlet.MyExceptions;
import fig.servlet.UpdateQueue;
import fig.servlet.UpdateSpec;
import fig.servlet.WebState;

class ReadyExecView
extends Item {
    public ReadyExecView(Item parent, String name, String sourcePath) {
        super(parent, name, sourcePath);
        IOUtils.createNewFileIfNotExistsEasy(sourcePath);
    }

    @Override
    public void update(UpdateSpec spec, UpdateQueue.Priority priority) throws MyException {
        super.update(spec, priority);
        OrderedMap<String, Item> newItems = new OrderedMap<String, Item>();
        for (Item item : this.items.values()) {
            if (!(item instanceof ExecItem) || !((ExecItem)item).isThunk()) continue;
            this.addItem(newItems, item);
        }
        this.items = newItems;
    }

    public ExecItem popAReadyExecItem(long freeMemory) throws MyException {
        ExecItem bestExecItem = null;
        int bestPriority = Integer.MAX_VALUE;
        for (Item _execItem : this.items.values()) {
            ExecItem execItem;
            if (!(_execItem instanceof ExecItem) || !(execItem = (ExecItem)_execItem).isThunk() || (long)execItem.getReqMemory() > freeMemory / 0x100000L || execItem.getPriority() >= bestPriority) continue;
            bestPriority = execItem.getPriority();
            bestExecItem = execItem;
        }
        if (bestExecItem != null) {
            WebState.logs("ReadyExecView: popped " + bestExecItem);
            OrderedMap<String, Item> newItems = new OrderedMap<String, Item>();
            for (Item item : this.items.values()) {
                if (item == bestExecItem) continue;
                this.addItem(newItems, item);
            }
            this.items = newItems;
            this.saveToDisk();
        }
        return bestExecItem;
    }

    @Override
    protected void addItem(Item item) {
        if (item instanceof ExecItem) {
            ExecItem execItem = (ExecItem)item;
            if (this.containsItem(execItem)) {
                return;
            }
            try {
                if (!execItem.isThunk() || execItem.getThunkHasBeenQueued()) {
                    return;
                }
                execItem.setThunkHasBeenQueued(true);
            }
            catch (MyException e) {
                WebState.logs("ReadyExecView: Unable to save thunkHasBeenQueued", item);
                return;
            }
            WebState.logs("ReadyExecView: queueing %s", item);
        }
        super.addItem(item);
    }

    @Override
    protected FieldListMap getItemsFields() {
        return ExecItem.createThunkFields();
    }

    @Override
    protected boolean isView() {
        return true;
    }

    @Override
    public Item newItem(String name) throws MyException {
        throw MyExceptions.unsupported;
    }

    @Override
    protected String getDescription() {
        return "List of executions ready to be run (thunks)";
    }
}

