/*
 * Decompiled with CFR 0.152.
 */
package gep.model;

import nuts.util.Indexer;

public class SplitContext {
    public static final SplitContext BEG = new SplitContext(-5.0, -5);
    public static final SplitContext TOP = new SplitContext(-1.0, -1);
    private final double u;
    private final int x;

    public double getU() {
        if (this.u < 0.0 || this.u > 1.0) {
            throw new RuntimeException();
        }
        return this.u;
    }

    public int getX() {
        if (this.x < 0) {
            throw new RuntimeException();
        }
        return this.x;
    }

    public int index(Indexer<Double> indexer) {
        if (this.u < 0.0) {
            throw new RuntimeException();
        }
        indexer.addToIndex((Double[])new Double[]{this.u});
        return indexer.o2i(this.u);
    }

    public String toString() {
        if (this.equals(TOP)) {
            return "TOP";
        }
        if (this.equals(BEG)) {
            return "BEG";
        }
        String result = "[" + this.x;
        result = result + "/" + (this.u < 0.0 ? "*" : "" + this.u) + "]";
        return result;
    }

    public String toString(Indexer<Double> hiddenIndexer, Indexer<String> observedIndexer) {
        if (this.equals(TOP)) {
            return "TOP";
        }
        if (this.equals(BEG)) {
            return "BEG";
        }
        String result = "[" + observedIndexer.i2o(this.x);
        result = result + "/" + (this.u < 0.0 ? "*" : "" + this.index(hiddenIndexer)) + "]";
        return result;
    }

    public int level() {
        if (this.u == -1.0 && this.x == -1) {
            return 2;
        }
        if (this.u == -1.0 && this.x >= 0) {
            return 1;
        }
        if (this.u >= 0.0 && this.x >= 0) {
            return 0;
        }
        if (this.equals(BEG)) {
            return 1;
        }
        throw new RuntimeException();
    }

    public SplitContext backoff() {
        int level = this.level();
        if (level == 2) {
            return null;
        }
        if (level == 1) {
            return TOP;
        }
        if (level == 0) {
            return new SplitContext(-1.0, this.x);
        }
        throw new RuntimeException();
    }

    public SplitContext(int x) {
        this(-1.0, x);
    }

    public SplitContext(double u, int x) {
        if (u >= 0.0 && x == -1) {
            throw new RuntimeException();
        }
        this.x = x;
        this.u = u;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.u);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.x;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SplitContext other = (SplitContext)obj;
        if (Double.doubleToLongBits(this.u) != Double.doubleToLongBits(other.u)) {
            return false;
        }
        return this.x == other.x;
    }
}

