/*
 * Decompiled with CFR 0.152.
 */
package goblin;

import fig.basic.StrUtils;
import goblin.ipa.IpaParser;
import goblin.ipa.ParseException;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nuts.io.IO;

public class IPADatabase {
    private final Set<Character> characters = new HashSet<Character>();
    private final Set allFeatures = new HashSet();
    private final Map<Character, Set> features = new HashMap<Character, Set>();
    private final Map<Object, Set<Character>> inverseFeatureMap = new HashMap<Object, Set<Character>>();
    public static List<String> consOrder = Arrays.asList("Place", "Manner", "Phonation");
    public static List<String> vowOrder = Arrays.asList("Roundedness", "Place", "Height");

    public Set<Character> characters() {
        return Collections.unmodifiableSet(this.characters);
    }

    public void associate(Character c, Object feature) {
        if (this.hasFeature(c, feature)) {
            IO.so("Warning: feature " + feature + " already associated with " + c);
            return;
        }
        this.characters.add(c);
        this.allFeatures.add(feature);
        if (!this.features.containsKey(c)) {
            this.features.put(c, new HashSet());
        }
        this.features.get(c).add(feature);
        if (!this.inverseFeatureMap.containsKey(feature)) {
            this.inverseFeatureMap.put(feature, new HashSet());
        }
        this.inverseFeatureMap.get(feature).add(c);
    }

    public boolean hasFeature(Character c, Object feature) {
        Set featureSet = this.features.get(c);
        if (featureSet == null) {
            return false;
        }
        return featureSet.contains(feature);
    }

    public Set features(char c) {
        return this.features.get(Character.valueOf(c));
    }

    public String toString() {
        String result = "";
        for (char c : this.characters) {
            result = result + c + " { ";
            for (Object feature : this.features.get(Character.valueOf(c))) {
                result = result + feature.toString() + " ";
            }
            result = result + "}\n";
        }
        return result;
    }

    public void toOldFormat(Appendable consOut, Appendable vowOut) throws IOException {
        for (char c : this.characters) {
            if (this.features.get(Character.valueOf(c)).contains("Vowel")) {
                vowOut.append("" + c + "\t" + StrUtils.join(this.toOldFeatureList(c, false)) + " vowel\n");
                continue;
            }
            consOut.append("" + c + "\t" + StrUtils.join(this.toOldFeatureList(c, true)) + " consonant\n");
        }
    }

    public List<String> toOldFeatureList(char c, boolean isCons) {
        Set featureSet = this.features.get(Character.valueOf(c));
        ArrayList<String> result = new ArrayList<String>();
        for (String featureName : isCons ? consOrder : vowOrder) {
            result.add(IPADatabase.findFeature(featureSet, featureName));
        }
        if (isCons) {
            if (featureSet.contains("OralConsonant")) {
                result.add("oral");
            } else if (featureSet.contains("NasalConsonant")) {
                result.add("nasal");
            } else {
                throw new RuntimeException();
            }
            if (featureSet.contains("LateralConsonant")) {
                result.add("lateral");
            } else if (featureSet.contains("CentralConsonant")) {
                result.add("central");
            } else {
                result.add("throat");
            }
        }
        return result;
    }

    private static String findFeature(Set featureSet, String prefix) {
        for (Object value : featureSet) {
            String str = value.toString();
            String[] fields = str.split(":");
            if (!fields[0].equals(prefix)) continue;
            return fields[1];
        }
        throw new RuntimeException();
    }

    public static void main(String[] args) throws ParseException, IOException {
        File file = new File("encodings/IPAFeatures");
        IpaParser parser = new IpaParser(file);
        parser.parse();
        IO.so(parser.db.toString());
        String outPrefix = "encodings/converted";
        PrintWriter consOut = new PrintWriter(outPrefix + "-cons.ipa");
        PrintWriter vowOut = new PrintWriter(outPrefix + "-vow.ipa");
        parser.db.toOldFormat(consOut, vowOut);
        consOut.close();
        vowOut.close();
    }
}

