/*
 * Decompiled with CFR 0.152.
 */
package goblin;

import fig.basic.ListUtils;
import goblin.CognateId;
import goblin.ReadEval;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nuts.io.IO;
import nuts.util.CollUtils;
import nuts.util.MathUtils;

public class ReadEvals {
    public static void main(String[] args) {
        if (args.length < 3) {
            IO.so("j goblin.ReadEvals <n-iters-to-inspected> <base-set-of-ids> (<exec-dirs-to-compare>)+");
            return;
        }
        int nGoblins = Integer.parseInt(args[0]);
        Map<CognateId, ReadEval.Evaluation> base = ReadEval.read(args[1]);
        List<String> execs = Arrays.asList(args).subList(2, args.length);
        double[][] numbers = new double[nGoblins][execs.size()];
        for (int e = 0; e < execs.size(); ++e) {
            for (int i = 0; i < nGoblins; ++i) {
                try {
                    Map<CognateId, ReadEval.Evaluation> current = ReadEval.read(execs.get(e) + ".exec/GOBLIN-" + i + ".eval");
                    double sum = 0.0;
                    Set<CognateId> inter = CollUtils.inter(base.keySet(), current.keySet());
                    for (CognateId key : inter) {
                        sum += current.get((Object)key).loss;
                    }
                    numbers[i][e] = sum / (double)inter.size();
                    continue;
                }
                catch (Exception ex) {
                    numbers[i][e] = Double.NaN;
                }
            }
        }
        for (String exec : execs) {
            IO.sos(exec + "\t");
        }
        IO.so();
        for (int i = 0; i < nGoblins; ++i) {
            for (int e = 0; e < execs.size(); ++e) {
                IO.sos("" + numbers[i][e] + "\t");
            }
            ArrayList<Double> values = ListUtils.toList(numbers[i]);
            try {
                IO.sos(MathUtils.bootstrapMean(values));
            }
            catch (Exception e) {
                IO.sos("N/A");
            }
            IO.so();
        }
    }
}

