/*
 * Decompiled with CFR 0.152.
 */
package ma;

import fig.basic.IOUtils;
import fig.basic.LogInfo;
import fig.basic.Option;
import fig.basic.UnorderedPair;
import goblin.CognateId;
import goblin.Taxon;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import ma.BioCorpus;
import ma.DistanceMtxParser;
import ma.MSAPoset;
import ma.MultiAlignment;
import ma.PrepareCorpus;
import ma.SequenceType;
import ma.newick.NewickParser;
import ma.newick.ParseException;
import nuts.io.IO;
import nuts.util.Tree;

public class BalibaseCorpus
extends BioCorpus {
    private final BalibaseCorpusOptions options;
    public static final String MSF_SUFFIX = "msf";
    public static final String CLUSTALW_TOPO_SUFFIX = "dnd";
    public static final String WEIGHBOR_TOPO_SUFFIX = "weitree";
    private Map<UnorderedPair<Taxon, Taxon>, Double> dist = null;
    private Map<CognateId, MultiAlignment> clustalwAlignments = null;

    private void init() {
        this.loadMSFAligns();
        this.loadTopos();
    }

    public BalibaseCorpus(BalibaseCorpusOptions options) {
        super(options.sequenceType);
        try {
            this.options = (BalibaseCorpusOptions)options.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new RuntimeException(cnse);
        }
        this.init();
        if (options.binarizeTrees) {
            this.binarize();
        }
    }

    public Map<UnorderedPair<Taxon, Taxon>, Double> getDistances() {
        if (this.dist != null) {
            return this.dist;
        }
        this.dist = new HashMap<UnorderedPair<Taxon, Taxon>, Double>();
        for (String path : this.options.referenceAlignmentsPath) {
            for (File file : IO.ls(new File(path), "distance")) {
                CognateId id = BalibaseCorpus.getId(file);
                this.dist.putAll(DistanceMtxParser.read(file, this.prefix(id)));
            }
        }
        return this.dist;
    }

    private void loadMSFAligns() {
        for (String cPath : this.options.referenceAlignmentsPath) {
            this.loadMSFAligns(new File(cPath));
        }
    }

    @Override
    public MSAPoset getMSAPoset(CognateId id) {
        if (this.options.ignoreAnn) {
            return MSAPoset.fromMultiAlignmentObject((MultiAlignment)this.multiAlignments.get(id));
        }
        return MSAPoset.coreBlocksFromMultiAlignmentObject((MultiAlignment)this.multiAlignments.get(id));
    }

    private void loadMSFAligns(File referenceAlignments) {
        for (File file : IO.ls(referenceAlignments, MSF_SUFFIX)) {
            try {
                CognateId id = BalibaseCorpus.getId(file);
                if (this.multiAlignments.containsKey(id)) {
                    throw new RuntimeException();
                }
                File annotationsFile = this.options.ignoreAnn ? null : BalibaseCorpus.getBalibaseAnnFile(file, referenceAlignments);
                MultiAlignment align = MultiAlignment.parseMSFToMultiAlignment(file.getPath(), this.options.ignoreAnn ? null : annotationsFile.getPath(), this.prefix(id));
                this.multiAlignments.put(id, align);
            }
            catch (AnnNotFound ann) {
                System.err.println("Annotation file not found.. file ignored:" + file);
            }
            catch (MultiAlignment.MSFParser.NoCoreBlockException ncbe) {
                System.err.println("No core block definition found, file " + file + " ignored.");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
    }

    public static File getBalibaseAnnFile(File fileWithSuffix, File referenceAlignments) {
        String proteinName = PrepareCorpus.proteinName(fileWithSuffix.getName());
        for (File file : IO.ls(referenceAlignments, "ann")) {
            if (!PrepareCorpus.proteinName(file).equals(proteinName)) continue;
            return file;
        }
        throw new AnnNotFound();
    }

    private String prefix(CognateId id) {
        return this.options.addPrefixToCognateIds ? id.toString() + "/" : "";
    }

    public static CognateId getId(File file) {
        return new CognateId(file.getParentFile().getParentFile().getName() + "/" + file.getParentFile().getName() + "/" + file.getName().replaceAll("[.].*", ""));
    }

    private void loadTopos() {
        for (String cPath : this.options.referenceAlignmentsPath) {
            this.loadTopos(new File(cPath));
        }
    }

    private void loadTopos(File referenceAlignments) {
        for (File file : IO.ls(referenceAlignments, this.options.topoSuffix)) {
            CognateId id = BalibaseCorpus.getId(file);
            try {
                NewickParser parser = new NewickParser(IOUtils.openIn(file));
                Tree<String> currentTopo = parser.parse();
                Map<Taxon, Double> bl = parser.getBranchLengths();
                currentTopo = this.addPrefix(this.prefix(id), currentTopo);
                bl = this.addPrefix(this.prefix(id), bl);
                for (Taxon lang : bl.keySet()) {
                    if (!(bl.get(lang) < this.options.minBranchLength)) continue;
                    LogInfo.warning("Setting to min branch length:" + bl.get(lang) + " -> " + this.options.minBranchLength);
                    bl.put(lang, this.options.minBranchLength);
                }
                this.topologies.put(id, currentTopo);
                this.branchLengths.put(id, bl);
            }
            catch (ParseException e) {
                System.err.println("Parse error in file " + file + ":" + e);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
    }

    private Map<Taxon, Double> addPrefix(String prefix, Map<Taxon, Double> bl) {
        HashMap<Taxon, Double> result = new HashMap<Taxon, Double>();
        for (Taxon initLang : bl.keySet()) {
            result.put(new Taxon(prefix + initLang.toString()), bl.get(initLang));
        }
        return result;
    }

    private Tree<String> addPrefix(String prefix, Tree<String> current) {
        current = current.deepCopy();
        for (Tree<String> node : current.getPostOrderTraversal()) {
            node.setLabel(prefix + node.getLabel());
        }
        return current;
    }

    public Map<CognateId, MultiAlignment> getClustalwAlignments() {
        if (this.clustalwAlignments == null) {
            this.loadClustalwAlignments();
        }
        return Collections.unmodifiableMap(this.clustalwAlignments);
    }

    private void loadClustalwAlignments() {
        this.clustalwAlignments = new HashMap<CognateId, MultiAlignment>();
        for (CognateId id : this.intersectedIds()) {
            File alnFile = new File(this.options.clustalwAlnPath, id.toString() + ".aln");
            try {
                this.clustalwAlignments.put(id, MultiAlignment.parseALNToMultiAlignment(alnFile.getPath(), this.prefix(id)));
            }
            catch (IOException e) {
                throw new RuntimeException();
            }
        }
    }

    public static class AnnNotFound
    extends RuntimeException {
    }

    public static class BalibaseCorpusOptions
    implements Cloneable {
        @Option
        public ArrayList<String> referenceAlignmentsPath = new ArrayList<String>(Arrays.asList("."));
        @Option
        public boolean binarizeTrees = true;
        @Option
        public String topoSuffix = "weitree";
        @Option
        public SequenceType sequenceType = SequenceType.PROTEIN;
        @Option
        public boolean ignoreAnn = false;
        @Option
        public String clustalwAlnPath = "";
        @Option
        public boolean addPrefixToCognateIds = true;
        @Option
        public double minBranchLength = 0.005;

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }
}

