/*
 * Decompiled with CFR 0.152.
 */
package ma;

import java.io.File;
import java.io.IOException;
import ma.MultiAlignment;
import nuts.io.IO;

public class Baselines {
    public static String clustalw = "/usr/bin/clustalw";
    public static String tkfalign = "/home/eecs/bouchard/goblin/others/dart/bin/tkfalign";
    private static String outputDir = "handel";
    private static int nSamples = 10000;

    public static void main(String[] args) throws IOException {
        if (args.length != 3) {
            System.err.println("3 options:  (path to clustalw or X if no clust to run) (path to handel or X if no handle) (n of handel samples)");
            return;
        }
        clustalw = args[0];
        tkfalign = args[1];
        nSamples = Integer.parseInt(args[2]);
        for (String file : IO.ls(".", "msf")) {
            System.out.println("Processing " + file);
            try {
                MultiAlignment ma = MultiAlignment.parseMSFToMultiAlignment(file);
                String fasta = MultiAlignment.toFASTA(ma);
                File tempFile = new File("temp");
                tempFile.deleteOnExit();
                IO.writeToDisk(tempFile.getPath(), fasta);
                if (!clustalw.toUpperCase().equals("X")) {
                    Baselines.clustalw(file, tempFile);
                }
                if (tkfalign.toUpperCase().equals("X")) continue;
                Baselines.handel(file, tempFile);
            }
            catch (Exception e) {
                System.err.println("Problem with " + file + ".. skipping");
            }
        }
    }

    private static void handel(String currentMSFFileName, File tempFASTAFile) throws IOException {
        String stemmed = currentMSFFileName.replaceAll("[.]msf", "");
        String treeFile = stemmed + ".weitree";
        System.out.println("Running tkfalign with " + nSamples + " samples");
        String result = IO.call(tkfalign + " -s " + nSamples + " " + treeFile + " " + tempFASTAFile.getPath());
        String alnConverted = Baselines.stock2ALN(result);
        File handelDir = new File(outputDir);
        handelDir.mkdir();
        String temp = "temp";
        File output1 = new File(handelDir, temp);
        output1.deleteOnExit();
        IO.writeToDisk(output1.getPath(), alnConverted);
        MultiAlignment ma = MultiAlignment.parseALNToMultiAlignment(output1.getPath(), "");
        IO.writeToDisk(new File(handelDir, currentMSFFileName).getPath(), ma.createAlignmentMatrix().toMSFString());
    }

    public static String stock2ALN(String input) {
        String[] lines = input.split("\n");
        String result = "";
        for (String line : lines) {
            if (!line.matches("^[^ ]+\\s+[A-Za-z- ]+$")) continue;
            result = result + line + "\n";
        }
        return result;
    }

    public static void clustalw(String currentMSFFileName, File tempFASTAFile) {
        IO.call(clustalw + " align -infile=" + tempFASTAFile.getPath());
        File alnFile = new File(tempFASTAFile + ".aln");
        File dndFile = new File(tempFASTAFile + ".dnd");
        dndFile.delete();
        File destination = new File(currentMSFFileName.replaceAll("[.]msf", "") + ".aln");
        alnFile.renameTo(destination);
        alnFile = destination;
    }
}

