/*
 * Decompiled with CFR 0.152.
 */
package ma;

import fig.basic.Option;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import ma.MSAParser;
import ma.MSAPoset;
import nuts.io.IO;
import nuts.math.Evaluator;

public class MSAEvaluator {
    public static List<Evaluator.EvaluationScorer<MSAPoset>> msaEvaluationScorers = Arrays.asList(new ColumnScore(), new EdgePrecision(), new EdgeRecall(), new EdgeF1(), new ReferenceAlignedFraction(), new ReferenceIdentityFraction(), new ReferenceNumSites(), new GuessAlignedFraction(), new GuessIdentityFraction(), new GuessNumSites());

    public static void main(String[] args) {
        IO.run(args, new MSAEvaluatorMain());
    }

    public static class EdgeF1
    extends MSAScorer {
        @Override
        public double score(MSAPoset refMSA, MSAPoset guessMSA) {
            return MSAPoset.edgeF1(refMSA, guessMSA);
        }

        public String toString() {
            return "EdgeF1";
        }
    }

    public static class EdgeRecall
    extends MSAScorer {
        @Override
        public double score(MSAPoset refMSA, MSAPoset guessMSA) {
            return MSAPoset.edgeRecall(refMSA, guessMSA);
        }

        public String toString() {
            return "EdgeRecall";
        }
    }

    public static class EdgePrecision
    extends MSAScorer {
        @Override
        public double score(MSAPoset refMSA, MSAPoset guessMSA) {
            return MSAPoset.edgePrecision(refMSA, guessMSA);
        }

        public String toString() {
            return "EdgePrecision";
        }
    }

    public static class ColumnScore
    extends MSAScorer {
        @Override
        public double score(MSAPoset refMSA, MSAPoset guessMSA) {
            return MSAPoset.columnRecall(refMSA, guessMSA);
        }

        public String toString() {
            return "ColumnScore";
        }
    }

    public static class GuessNumSites
    extends MSAScorer {
        @Override
        public double score(MSAPoset refMSA, MSAPoset guessMSA) {
            return guessMSA.columns().size();
        }

        public String toString() {
            return "GuessNumSites";
        }
    }

    public static class GuessAlignedFraction
    extends MSAScorer {
        @Override
        public double score(MSAPoset refMSA, MSAPoset guessMSA) {
            return guessMSA.getAlignedStatistics();
        }

        public String toString() {
            return "GuessAlignedFraction";
        }
    }

    public static class GuessIdentityFraction
    extends MSAScorer {
        @Override
        public double score(MSAPoset refMSA, MSAPoset guessMSA) {
            return guessMSA.getIdentityStatistic();
        }

        public String toString() {
            return "GuessIdentityFraction";
        }
    }

    public static class ReferenceNumSites
    extends MSAScorer {
        @Override
        public double score(MSAPoset refMSA, MSAPoset guessMSA) {
            return refMSA.columns().size();
        }

        public String toString() {
            return "ReferenceNumSites";
        }
    }

    public static class ReferenceAlignedFraction
    extends MSAScorer {
        @Override
        public double score(MSAPoset refMSA, MSAPoset guessMSA) {
            return refMSA.getAlignedStatistics();
        }

        public String toString() {
            return "ReferenceAlignedFraction";
        }
    }

    public static class ReferenceIdentityFraction
    extends MSAScorer {
        @Override
        public double score(MSAPoset refMSA, MSAPoset guessMSA) {
            return refMSA.getIdentityStatistic();
        }

        public String toString() {
            return "ReferenceIdentityFraction";
        }
    }

    public static abstract class MSAScorer
    implements Evaluator.EvaluationScorer<MSAPoset> {
        @Override
        public double worstScore() {
            return 0.0;
        }

        public boolean equals(Object obj) {
            return this.toString().equals(obj);
        }

        public int hashCode() {
            return this.toString().hashCode();
        }
    }

    public static class MSAEvaluatorMain
    implements Runnable {
        @Option(required=true)
        public File refDirectory;
        @Option(required=true)
        public File guessDirectory;
        @Option
        public String refSuffix = null;
        @Option
        public String guessSuffix = null;

        @Override
        public void run() {
            Evaluator.evaluate(this.refDirectory, this.refSuffix, this.guessDirectory, this.guessSuffix, new MSAParser(), msaEvaluationScorers);
        }
    }
}

