/*
 * Decompiled with CFR 0.152.
 */
package monaco.prop;

import fig.prob.SampleUtils;
import java.util.List;
import java.util.Random;
import monaco.prop.Proposal;
import monaco.prop.ProposalProvider;
import nuts.util.MathUtils;

public class ProposalCombination<S>
implements ProposalProvider<S> {
    private final List<ProposalProvider<S>> proposals;
    private final double[] probabilities;

    public ProposalCombination(List<ProposalProvider<S>> proposals, double[] probabilities) {
        if (proposals.size() != probabilities.length) {
            throw new RuntimeException();
        }
        if (!MathUtils.isProb(probabilities)) {
            throw new RuntimeException();
        }
        this.proposals = proposals;
        this.probabilities = probabilities;
    }

    @Override
    public Proposal<S> proposal(Random rand, S particle) {
        int index = SampleUtils.sampleMultinomial(rand, this.probabilities);
        return this.proposals.get(index).proposal(rand, particle);
    }

    @Override
    public String name() {
        return "ProposalCombination";
    }
}

