/*
 * Decompiled with CFR 0.152.
 */
package monaco.prop;

import fig.basic.Pair;
import java.util.Random;
import monaco.prop.Proposal;
import monaco.prop.ProposalProvider;
import nuts.math.Sampling;

public class RepeatedProposalProvider<S>
implements ProposalProvider<S> {
    private final ProposalProvider<S> pp;
    private final double repeatRate;

    public RepeatedProposalProvider(ProposalProvider<S> pp, double repeatRate) {
        this.pp = pp;
        this.repeatRate = repeatRate;
    }

    @Override
    public Proposal<S> proposal(Random rand, S particle) {
        final int nRepeats = Sampling.sampleGeometric(rand, this.repeatRate) + 1;
        return new Proposal<S>(){

            @Override
            public Pair<S, Double> propose_logRatio(Random rand, S current, boolean avoidExtensiveCaching) {
                double logSum = 0.0;
                for (int i = 0; i < nRepeats; ++i) {
                    Proposal prop = RepeatedProposalProvider.this.pp.proposal(rand, current);
                    Pair cur = prop.propose_logRatio(rand, current, avoidExtensiveCaching);
                    current = cur.getFirst();
                    logSum += cur.getSecond().doubleValue();
                }
                return Pair.makePair(current, logSum);
            }

            @Override
            public String name() {
                return RepeatedProposalProvider.this.pp.name();
            }
        };
    }

    @Override
    public String name() {
        return "geo(" + this.repeatRate + ") x " + this.pp.name();
    }
}

