/*
 * Decompiled with CFR 0.152.
 */
package nuts.lang;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    public static final char BOUND = '#';

    public static List<String> selectRegex(String regex, String string) {
        return StringUtils.selectRegex(Pattern.compile(regex), string);
    }

    public static List<String> selectRegex(Pattern p, String string) {
        ArrayList<String> result = new ArrayList<String>();
        Matcher m = p.matcher(string);
        while (m.find()) {
            result.add(m.group(1));
        }
        return result;
    }

    public static List<String> multiSelectFirstRegex(String p, String string) {
        return StringUtils.multiSelectFirstRegex(Pattern.compile(p), string);
    }

    public static List<String> multiSelectFirstRegex(Pattern p, String string) {
        Matcher m = p.matcher(string);
        ArrayList<String> result = new ArrayList<String>();
        if (!m.find()) {
            return result;
        }
        for (int i = 1; i <= m.groupCount(); ++i) {
            result.add(m.group(i));
        }
        return result;
    }

    public static String selectFirstRegex(Pattern p, String string) {
        List<String> result = StringUtils.selectRegex(p, string);
        if (result.size() == 0) {
            return null;
        }
        return result.get(0);
    }

    public static String selectFirstRegex(String regex, String string) {
        return StringUtils.selectFirstRegex(Pattern.compile(regex), string);
    }

    public static char charAt(String word, int position, char outOfStringChar) {
        if (position < 0 || position >= word.length()) {
            return outOfStringChar;
        }
        return word.charAt(position);
    }

    public static char charAt(String word, int pos) {
        return StringUtils.charAt(word, pos, '#');
    }

    public static StringBuilder spaces(int number) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < number; ++i) {
            result.append(" ");
        }
        return result;
    }

    public static void main(String[] args) {
        System.out.println(StringUtils.selectRegex(".(.).(.).", "abcde12345"));
    }
}

