/*
 * Decompiled with CFR 0.152.
 */
package nuts.math;

import fig.basic.IOUtils;
import fig.basic.Option;
import fig.basic.Pair;
import fig.exec.Execution;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import nuts.io.CSV;
import nuts.io.IO;
import nuts.math.StatisticsMap;
import nuts.util.CollUtils;

public class Plot2D {
    @Option
    public static String rPath = "r";
    public static Plot2DOptions defaultPlot2DOptions = new Plot2DOptions();
    private boolean printLegend = false;
    private List<List<Point>> datasets = CollUtils.list();
    private List<String> datasetNames = CollUtils.list();
    private List<Boolean> connects = CollUtils.list();
    private List<Boolean> hasCIs = CollUtils.list();
    private final Plot2DOptions options;

    public int getPermuted(int n) {
        if (this.options.stypeMapping == null || n >= this.options.stypeMapping.size()) {
            return n;
        }
        return this.options.stypeMapping.get(n);
    }

    public Plot2D(Plot2DOptions options) {
        this.options = options;
    }

    public Plot2D() {
        this.options = defaultPlot2DOptions;
    }

    public void addSeries(List<Point> _points, boolean connect, String name, boolean sortPoints, boolean printCIs, int samplingInterval) {
        if (sortPoints) {
            _points = CollUtils.list(_points);
            Collections.sort(_points, new Comparator<Point>(){

                @Override
                public int compare(Point arg0, Point arg1) {
                    return Double.compare(arg0.x, arg1.x);
                }
            });
        }
        ArrayList points = CollUtils.list();
        for (int i = 0; i < _points.size(); ++i) {
            if (i % samplingInterval != 0) continue;
            points.add(_points.get(i));
        }
        if (name == null) {
            name = "";
        }
        this.datasets.add(points);
        this.connects.add(connect);
        this.hasCIs.add(printCIs);
        this.datasetNames.add(name);
        if (!name.equals("")) {
            this.printLegend = true;
        }
    }

    public void addSeries(List<Pair<Double, Double>> numbers) {
        this.addSeries(numbers, "");
    }

    public void addSeries(List<Pair<Double, Double>> numbers, String name) {
        this.addSeries(numbers, this.options.connects, name);
    }

    public void addSeries(List<Pair<Double, Double>> numbers, boolean connect, String name) {
        ArrayList<Point> points = CollUtils.list();
        for (Pair<Double, Double> n : numbers) {
            points.add(new Point(n.getFirst(), n.getSecond()));
        }
        this.addSeries(points, connect, name, false, false, 1);
    }

    public void addTimeSeries(List<Double> numbers) {
        this.addTimeSeries(numbers, "");
    }

    public void addTimeSeries(List<Double> numbers, String name) {
        this.addTimeSeries(numbers, this.options.connects, name);
    }

    public void addTimeSeries(List<Double> numbers, boolean connect, String name) {
        ArrayList<Pair<Double, Double>> pairs = CollUtils.list();
        for (int i = 0; i < numbers.size(); ++i) {
            pairs.add(Pair.makePair(Double.valueOf(i), numbers.get(i)));
        }
        this.addSeries(pairs, connect, name);
    }

    public List<Pair<Integer, String>> symbolColors(int n) {
        ArrayList<Pair<Integer, String>> list = CollUtils.list();
        for (int _i = 0; _i < n; ++_i) {
            int i = this.getPermuted(_i);
            list.add(Pair.makePair(1 + i % 19, "'" + this.options.colors.get(i % this.options.colors.size()) + "'"));
        }
        return list;
    }

    public String symbolColorsStr(int n) {
        int i;
        StringBuilder result = new StringBuilder();
        result.append("pch=c(");
        List<Pair<Integer, String>> list = this.symbolColors(n);
        for (i = 0; i < n; ++i) {
            result.append("" + list.get(i).getFirst() + (i == n - 1 ? "" : ","));
        }
        result.append("),");
        if (this.allConnect()) {
            result.append("lty=c(");
            for (i = 0; i < n; ++i) {
                result.append("" + list.get(i).getFirst() + (i == n - 1 ? "" : ","));
            }
            result.append("),");
        }
        result.append("col=c(");
        for (i = 0; i < n; ++i) {
            result.append("" + list.get(i).getSecond() + (i == n - 1 ? "" : ","));
        }
        result.append(")");
        return result.toString();
    }

    public void savePlot(File outputPDFFile) {
        int i;
        File tempDir = IO.getTempDir("r-temp");
        File rScriptFile = new File(tempDir, "script.r");
        PrintWriter rscript = IOUtils.openOutEasy(rScriptFile);
        rscript.println("pdf('" + Plot2D.escapeQuote(outputPDFFile.getAbsolutePath()) + "')");
        rscript.println("par(ps=30)");
        this.initPlot(tempDir, rscript);
        for (int miniI = 1; miniI <= 4; ++miniI) {
            rscript.println("axis(" + miniI + ",lwd=" + this.options.axesWidth + ")");
        }
        rscript.println("box(lwd=" + this.options.axesWidth + ")");
        if (this.printLegend) {
            String legendStr = "legend('" + (Object)((Object)this.options.legendPlacement) + "', c(";
            for (i = 0; i < this.datasets.size(); ++i) {
                legendStr = legendStr + "'" + (this.datasetNames.get(i).equals("") ? "Series " + i : Plot2D.escapeQuote(this.datasetNames.get(i))) + "'" + (i == this.datasetNames.size() - 1 ? "" : ",");
            }
            legendStr = legendStr + "), " + this.symbolColorsStr(this.datasets.size());
            legendStr = legendStr + ",bty='n',lwd=" + this.options.lineWidth + ",y.intersp=2)";
            rscript.println(legendStr);
        }
        List<Pair<Integer, String>> list = this.symbolColors(this.datasets.size());
        for (i = 0; i < this.datasets.size(); ++i) {
            Pair<Integer, String> curSymCol = list.get(i);
            File curFile = new File(tempDir, "dataset" + i + ".csv");
            Plot2D.writeCSVToFile(curFile, this.datasets.get(i));
            rscript.println("data" + i + " <- read.table('" + Plot2D.escapeQuote(curFile.getAbsolutePath()) + "',sep=',')");
            rscript.println("points(data" + i + ",col=" + curSymCol.getSecond() + ",pch=" + curSymCol.getFirst() + (this.connects.get(i) != false ? ",type='b',lwd=" + this.options.lineWidth + ",lty=" + curSymCol.getFirst() : "") + ")");
            if (!this.hasCIs.get(i).booleanValue() || this.options.doNotPrintCIs) continue;
            File curFiled = new File(tempDir, "datasetd" + i + ".csv");
            File curFileu = new File(tempDir, "datasetu" + i + ".csv");
            File xF = new File(tempDir, "xF" + i + ".csv");
            Plot2D.writeCIsToFile(curFiled, this.datasets.get(i), true);
            Plot2D.writeCIsToFile(curFileu, this.datasets.get(i), false);
            Plot2D.writeXsToFile(xF, this.datasets.get(i));
            rscript.println("datad" + i + " <- as.vector(as.matrix(read.table('" + Plot2D.escapeQuote(curFiled.getAbsolutePath()) + "',sep=',')))");
            rscript.println("datau" + i + " <- as.vector(as.matrix(read.table('" + Plot2D.escapeQuote(curFileu.getAbsolutePath()) + "',sep=',')))");
            rscript.println("x" + i + " <- as.vector(as.matrix(read.table('" + Plot2D.escapeQuote(xF.getAbsolutePath()) + "',sep=',')))");
            rscript.println("arrows(x" + i + ",datad" + i + ",x" + i + ",datau" + i + ",col=" + curSymCol.getSecond() + ",code=3,length=0.1,angle=90,lwd=" + this.options.lineWidth + ")");
        }
        rscript.println("dev.off()");
        rscript.close();
        File rOut = new File(tempDir, "rOut");
        IO.call("" + rPath + " CMD BATCH " + rScriptFile.getName() + " " + rOut.getName(), null, tempDir);
    }

    private boolean allConnect() {
        for (boolean cur : this.connects) {
            if (cur) continue;
            return false;
        }
        return true;
    }

    private void initPlot(File tempDir, PrintWriter rscript) {
        File curFile = new File(tempDir, "dataset-init.csv");
        Plot2D.writeCSVToFile(curFile, this.minmaxdata());
        rscript.println("data <- read.table('" + Plot2D.escapeQuote(curFile.getAbsolutePath()) + "',sep=',')");
        rscript.println("plot(data,type='n'," + this.plotOptions() + ")");
    }

    private List<Point> minmaxdata() {
        double minX = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        for (List<Point> dataset : this.datasets) {
            for (Point datum : dataset) {
                double x = datum.x;
                double y = datum.y;
                if (x < minX) {
                    minX = x;
                }
                if (datum.ciD < minY) {
                    minY = datum.ciD;
                }
                if (x > maxX) {
                    maxX = x;
                }
                if (!(datum.ciU > maxY)) continue;
                maxY = datum.ciU;
            }
        }
        ArrayList<Point> result = CollUtils.list();
        result.add(new Point(minX, minY));
        result.add(new Point(maxX, maxY));
        return result;
    }

    private String plotOptions() {
        String str = "xlab='" + Plot2D.escapeQuote(this.options.xAxis) + "',ylab='" + Plot2D.escapeQuote(this.options.yAxis) + "'";
        if (this.options.noBox) {
            str = str + ",bty = \"n\"";
        }
        if (this.options.xlogscale || this.options.ylogscale) {
            if (this.options.xlogscale && !this.options.ylogscale) {
                str = str + ",log='x'";
            }
            if (!this.options.xlogscale && this.options.ylogscale) {
                str = str + ",log='y'";
            }
            if (this.options.xlogscale && this.options.ylogscale) {
                str = str + ",log='xy'";
            }
        }
        return str;
    }

    public static String escapeQuote(String str) {
        str = str.replace("\\", "\\\\");
        return str.replace("'", "\\'");
    }

    public static void writeCSVToFile(File f, List<Point> series) {
        PrintWriter out = IOUtils.openOutEasy(f);
        for (Point item : series) {
            out.println(CSV.body(item.x, item.y));
        }
        out.close();
    }

    public static void writeCIsToFile(File f, List<Point> series, boolean down) {
        PrintWriter out = IOUtils.openOutEasy(f);
        for (Point item : series) {
            out.println(CSV.body(down ? item.ciD : item.ciU));
        }
        out.close();
    }

    public static void writeXsToFile(File f, List<Point> series) {
        PrintWriter out = IOUtils.openOutEasy(f);
        for (Point item : series) {
            out.println(CSV.body(item.x));
        }
        out.close();
    }

    public static void main(String[] args) {
        IO.run(args, new Tester(), "opt", defaultPlot2DOptions);
    }

    public static class Tester
    implements Runnable {
        @Override
        public void run() {
            File out = new File(Execution.getFile("output.pdf"));
            Plot2DFactory fac = new Plot2DFactory();
            fac.add("series", 2.0, 3.0);
            fac.add("series", 2.0, 4.0);
            fac.add("series", 2.0, 5.0);
            fac.add("series", 3.0, 3.0);
            fac.add("series", 3.0, 10.0);
            fac.add("series", 3.0, 5.0);
            fac.add("series2", 2.0, -3.0);
            fac.add("series2", 2.0, -4.0);
            fac.add("series2", 2.0, -5.0);
            fac.add("series2", 3.0, -3.0);
            fac.add("series2", 3.0, -10.0);
            fac.add("series2", 3.0, -5.0);
            fac.getPlot2D().savePlot(out);
        }
    }

    public static class Plot2DFactory {
        private final Plot2DOptions options;
        private Map<String, StatisticsMap.DescriptiveStatisticsMap<Double>> data = CollUtils.map();

        public Plot2DFactory(Plot2DOptions options) {
            this.options = options;
        }

        public Plot2DFactory() {
            this(defaultPlot2DOptions);
        }

        public void add(String seriesName, double x, double y) {
            StatisticsMap.DescriptiveStatisticsMap<Double> currentMap = this.data.get(seriesName);
            if (currentMap == null) {
                currentMap = new StatisticsMap.DescriptiveStatisticsMap();
                this.data.put(seriesName, currentMap);
            }
            currentMap.addValue(x, y);
        }

        public Plot2D getPlot2D() {
            Plot2D result = new Plot2D(this.options);
            ArrayList<String> keys = CollUtils.list(this.data.keySet());
            Collections.sort(keys);
            for (String key : keys) {
                StatisticsMap.DescriptiveStatisticsMap<Double> currentMap = this.data.get(key);
                if (this.options.timingBinSize > 1) {
                    currentMap = Plot2DFactory.timingBinning(currentMap, this.options.timingBinSize);
                }
                if (!this.options.nDataPointsNeeded.equals("*")) {
                    currentMap = Plot2DFactory.removePointsBelowThreshold(currentMap, Integer.parseInt(this.options.nDataPointsNeeded));
                }
                ArrayList<Point> current = CollUtils.list();
                Iterator iterator = currentMap.keySet().iterator();
                while (iterator.hasNext()) {
                    double x = (Double)iterator.next();
                    if (this.options.useQuantileSummaries) {
                        current.add(new Point(x, currentMap.median(x), currentMap.percentile(x, 0.25), currentMap.percentile(x, 0.75)));
                        continue;
                    }
                    current.add(new Point(x, currentMap.mean(x), currentMap.mean(x) - currentMap.getSummaryStat(x).getStandardDeviation(), currentMap.mean(x) + currentMap.getSummaryStat(x).getStandardDeviation()));
                }
                result.addSeries(current, this.options.connects, key, true, true, this.options.samplingInterval);
            }
            return result;
        }

        private static StatisticsMap.DescriptiveStatisticsMap<Double> timingBinning(StatisticsMap.DescriptiveStatisticsMap<Double> currentMap, int timingBinSize) {
            throw new RuntimeException();
        }

        private static StatisticsMap.DescriptiveStatisticsMap<Double> removePointsBelowThreshold(StatisticsMap.DescriptiveStatisticsMap<Double> currentMap, int nRequested) {
            throw new RuntimeException();
        }
    }

    public static class Plot2DFactories {
        public final Plot2DOptions options;
        private Map<String, Plot2DFactory> factories = CollUtils.map();

        public Plot2DFactories(Plot2DOptions options) {
            this.options = options;
        }

        public Plot2DFactories() {
            this(defaultPlot2DOptions);
        }

        public Plot2DFactory getFactory(String key) {
            return CollUtils.getNoNull(this.factories, key, new Plot2DFactory(this.options));
        }

        public void saveAllPlots(File directory) {
            directory.mkdir();
            for (String key : this.factories.keySet()) {
                File plotFile = new File(directory, key.replaceAll("[/]", "_") + ".pdf");
                Plot2D plot = this.factories.get(key).getPlot2D();
                plot.savePlot(plotFile);
            }
        }
    }

    public static class Point {
        private final double x;
        private final double y;
        private final double ciD;
        private final double ciU;

        public Point(double x, double y, double ciD, double ciU) {
            this.x = x;
            this.y = y;
            this.ciD = ciD;
            this.ciU = ciU;
        }

        public Point(double x, double y) {
            this.x = x;
            this.y = y;
            this.ciD = y;
            this.ciU = y;
        }
    }

    public static enum LegendPlacements {
        topright,
        topleft,
        bottomleft,
        bottomright;

    }

    public static class Plot2DOptions {
        @Option
        public String xAxis = "";
        @Option
        public String yAxis = "";
        @Option
        public boolean xlogscale = false;
        @Option
        public boolean ylogscale = false;
        @Option
        public LegendPlacements legendPlacement = LegendPlacements.topright;
        @Option
        public boolean connects = true;
        @Option
        public int samplingInterval = 1;
        @Option
        public ArrayList<Integer> stypeMapping = null;
        @Option
        public int lineWidth = 5;
        @Option
        public int axesWidth = 5;
        @Option
        public boolean noBox = false;
        @Option
        public ArrayList<String> colors = new ArrayList<String>(Arrays.asList("blue4", "darkred", "darkgray", "darkgreen", "black", "darkorange", "yellow"));
        @Option
        public boolean doNotPrintCIs = false;
        @Option
        public boolean useQuantileSummaries = true;
        @Option
        public String nDataPointsNeeded = "*";
        @Option
        public int timingBinSize = 1;
    }
}

