/*
 * Decompiled with CFR 0.152.
 */
package nuts.maxent;

import java.util.Arrays;
import java.util.List;
import nuts.maxent.FeatureExtractor;
import nuts.maxent.HomogeneousBaseMeasures;
import nuts.maxent.LabeledInstance;
import nuts.maxent.MaxentClassifier;
import nuts.util.Counter;

public class MaxentClassifierTest {
    public static void main(String[] args) {
        LabeledInstance<String[], String> datum1 = new LabeledInstance<String[], String>("cat", new String[]{"fuzzy", "claws", "small"});
        LabeledInstance<String[], String> datum2 = new LabeledInstance<String[], String>("bear", new String[]{"fuzzy", "claws", "big"});
        LabeledInstance<String[], String> datum3 = new LabeledInstance<String[], String>("cat", new String[]{"claws", "medium"});
        LabeledInstance<String[], String> datum4 = new LabeledInstance<String[], String>("cat", new String[]{"claws", "small"});
        Counter training = new Counter();
        training.incrementCount(datum1, 1.0);
        training.incrementCount(datum2, 1.0);
        training.incrementCount(datum3, 1.0);
        FeatureExtractor<LabeledInstance<String[], String>, String> featureExtractor = new FeatureExtractor<LabeledInstance<String[], String>, String>(){

            @Override
            public Counter<String> extractFeatures(LabeledInstance<String[], String> datum) {
                Counter<String> result = new Counter<String>();
                for (String feature : datum.getInput()) {
                    result.incrementCount(feature + "-" + datum.getLabel(), 1.0);
                }
                return result;
            }

            @Override
            public double regularizationFactor(String feature) {
                return 1.0;
            }
        };
        List<String> labels = Arrays.asList("cat", "bear");
        HomogeneousBaseMeasures fbm = new HomogeneousBaseMeasures(labels);
        MaxentClassifier<String[], String, String> maxent = MaxentClassifier.learnMaxentClassifier(fbm, training, featureExtractor);
        System.out.println(maxent.getLabels(datum4.getInput()));
        System.out.println(Arrays.toString(maxent.logProb(datum4.getInput())));
    }

    public static class NGramFE
    implements FeatureExtractor<LabeledInstance<List<String>, String>, String> {
        @Override
        public Counter<String> extractFeatures(LabeledInstance<List<String>, String> instance) {
            Counter<String> newCounter = new Counter<String>();
            for (int n = 1; n <= instance.getInput().size(); ++n) {
                List<String> previousWords = instance.getInput().subList(instance.getInput().size() - n, instance.getInput().size());
                String featureName = "" + n + "gram:" + previousWords.toString() + "_" + instance.getLabel();
                newCounter.incrementCount(featureName, 1.0);
            }
            return newCounter;
        }

        @Override
        public double regularizationFactor(String feature) {
            return 1.0;
        }
    }
}

