/*
 * Decompiled with CFR 0.152.
 */
package nuts.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public final class Indexer<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<T> i2o = new ArrayList<T>();
    private final Map<T, Integer> o2i = new HashMap<T, Integer>();

    public Set<T> objects() {
        return Collections.unmodifiableSet(this.o2i.keySet());
    }

    public Indexer() {
    }

    public Indexer(Collection<T> coll) {
        this.addAllToIndex(coll);
    }

    public T i2o(int i) {
        return this.i2o.get(i);
    }

    public int o2i(T o) {
        Integer index = this.o2i.get(o);
        if (index == null) {
            throw new NoSuchElementException("" + o);
        }
        return index;
    }

    public int o2iEasy(T o) {
        Integer index = this.o2i.get(o);
        if (index == null) {
            return -1;
        }
        return index;
    }

    public void addAllToIndex(Collection<T> os) {
        for (T o : os) {
            if (this.containsObject(o)) continue;
            this.i2o.add(o);
            this.o2i.put(o, this.i2o.size() - 1);
        }
    }

    public void addToIndex(T ... os) {
        this.addAllToIndex(Arrays.asList(os));
    }

    public boolean containsIndex(int i) {
        return i >= 0 && i < this.i2o.size();
    }

    public boolean containsObject(T o) {
        return this.o2i.containsKey(o);
    }

    public int size() {
        return this.i2o.size();
    }

    public String toString() {
        return this.i2o.toString();
    }

    public int hashCode() {
        return this.i2o.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof Indexer)) {
            return false;
        }
        Indexer o_cast = (Indexer)o;
        return this.i2o.equals(o_cast.i2o);
    }
}

