/*
 * Decompiled with CFR 0.152.
 */
package nuts.util;

import fig.basic.IOUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WikiConverter {
    private WikiConversionRules rules;
    private String newlinecode = "\u21b5";

    public WikiConverter(Wiki2HtmlConversionRules rules) {
        this.rules = rules;
    }

    public String convert(BufferedReader in) throws IOException {
        StringBuilder builder = new StringBuilder();
        String line = null;
        while ((line = in.readLine()) != null) {
            builder.append(line);
            builder.append(this.newlinecode);
        }
        String result = builder.toString();
        result = this.convertHeader(result);
        result = this.convertItalic(result);
        result = this.convertBold(result);
        result = this.convertList(result);
        return result.replaceAll(this.newlinecode, "\n");
    }

    private String convertList(String input) {
        Pattern p = Pattern.compile(this.newlinecode + "([ ]*)[*] ([^" + this.newlinecode + "]*)" + this.newlinecode);
        Matcher m = p.matcher(input);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            int depth = Integer.parseInt(m.group(1));
            String replacement = this.rules.convertList(depth, m.group(2));
            m.appendReplacement(sb, replacement);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private String convertBold(String input) {
        Pattern p = Pattern.compile("[*]([^ ][^*]*[^ ])[*]");
        Matcher m = p.matcher(input);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String replacement = this.rules.convertBold(m.group(1));
            m.appendReplacement(sb, replacement);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private String convertItalic(String input) {
        Pattern p = Pattern.compile("[/]([^/]*)[/]");
        Matcher m = p.matcher(input);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String replacement = this.rules.convertItalic(m.group(1));
            m.appendReplacement(sb, replacement);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private String convertHeader(String input) {
        String field = "([^" + this.newlinecode + "]*)";
        Pattern p = Pattern.compile("^Title: " + field + this.newlinecode + "Tags: " + field + this.newlinecode + "Binary: " + field + this.newlinecode + "Last updated: " + field + this.newlinecode + "Owner: " + field + this.newlinecode + "Last updated by: " + field + this.newlinecode);
        Matcher m = p.matcher(input);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String replacement = this.rules.convertHeader(m.group(1), m.group(2), m.group(3), m.group(4), m.group(5), m.group(6));
            m.appendReplacement(sb, replacement);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static void main(String[] args) throws IOException {
        BufferedReader in = IOUtils.openIn("/Users/alex/Documents/downloads/xjlj20060409/vieux_dublin.txt");
        WikiConverter converter = new WikiConverter(new Wiki2HtmlConversionRules());
        System.out.println(converter.convert(in));
    }

    public static class Wiki2HtmlConversionRules
    implements WikiConversionRules {
        @Override
        public String convertHeader(String title, String tags, String binary, String lastUpdated, String owner, String lastUpdatedBy) {
            return "";
        }

        @Override
        public String convertItalic(String contents) {
            return "<em>" + contents + "</em>";
        }

        @Override
        public String convertBold(String contents) {
            return "<b>" + contents + "</b>";
        }

        @Override
        public String convertList(int depth, String string) {
            return "";
        }
    }

    public static interface WikiConversionRules {
        public String convertHeader(String var1, String var2, String var3, String var4, String var5, String var6);

        public String convertList(int var1, String var2);

        public String convertBold(String var1);

        public String convertItalic(String var1);
    }
}

