/*
 * Decompiled with CFR 0.152.
 */
package pedi.factor;

import fenchel.factor.FactorUtils;
import fenchel.factor.multisites.MSFactorGraph;
import fig.basic.LogInfo;
import fig.basic.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nuts.math.Graph;
import nuts.math.Graphs;
import nuts.math.MutableGraph;
import nuts.tui.Table;
import nuts.util.CollUtils;
import pedi.Genotype;
import pedi.Genotypes;
import pedi.Individual;
import pedi.Pedigree;
import pedi.PedigreeUtils;
import pedi.RegularPedigree;
import pedi.factor.FactorEncodings;
import pedi.factor.PedigreeNode;

public class Pedigree2FactorGraph {
    @Deprecated
    public static MSFactorGraph<PedigreeNode> pedigreeFactorGraph(RegularPedigree p, Genotypes g) {
        LogInfo.track((Object)"Creating simplestPedigreeFactorGraph", true);
        MSFactorGraph<PedigreeNode> fg = FactorUtils.newFactorGraph();
        Pedigree2FactorGraph.addGenotypeFactors(p, g, fg);
        Pedigree2FactorGraph.addInheritanceFactors(p, fg, g.getFactorEncodings());
        Pedigree2FactorGraph.addIndependentRecombFactors(p, fg, g.genomeSize());
        Pedigree2FactorGraph.addSimpleFounderFactors(p, Pedigree2FactorGraph.getUniformHardyWeinbergDistribution(g.genomeSize(), g.getFactorEncodings(), 0.5), fg);
        Pedigree2FactorGraph.addAllelePresenceFactors(p, g.getFactorEncodings(), fg);
        Pedigree2FactorGraph.addAlleleFactors(p, g.getFactorEncodings(), fg);
        Pedigree2FactorGraph.check(p, fg);
        LogInfo.logs(Pedigree2FactorGraph.summarize(fg.getTopology()));
        LogInfo.end_track();
        return fg;
    }

    public static void check(RegularPedigree p, MSFactorGraph<PedigreeNode> fg) {
        int nFou;
        int nInh = Pedigree2FactorGraph.getAllNodesOfType(PedigreeNode.PedigreeNodeType.INHERITANCE, fg.getTopology().vertexSet()).size();
        int nInd = p.individuals().size();
        if (nInd - (nFou = p.founders().size()) != nInh) {
            throw new RuntimeException();
        }
    }

    public static Set<PedigreeNode> getAllNodesOfType(PedigreeNode.PedigreeNodeType t, Collection<PedigreeNode> allNodes) {
        HashSet<PedigreeNode> result = new HashSet<PedigreeNode>();
        for (PedigreeNode n : allNodes) {
            if (n.type != t) continue;
            result.add(n);
        }
        return result;
    }

    public static String summarize(Graph<PedigreeNode> fg) {
        Table t = new Table();
        int r = 0;
        for (PedigreeNode.PedigreeNodeType type : PedigreeNode.PedigreeNodeType.values()) {
            t.set(r, 0, type.toString() + " ");
            t.set(r, 1, "" + Pedigree2FactorGraph.getAllNodesOfType(type, fg.vertexSet()).size());
            ++r;
        }
        return t.toString(false);
    }

    @Deprecated
    public static List<Graph<PedigreeNode>> simpleAcyclicGraphDecomposition(RegularPedigree p, Graph<PedigreeNode> fullGraph) {
        if (Graphs.isTree(fullGraph)) {
            throw new RuntimeException();
        }
        MutableGraph<PedigreeNode> g0 = new MutableGraph<PedigreeNode>(fullGraph);
        MutableGraph<PedigreeNode> g1 = new MutableGraph<PedigreeNode>(fullGraph);
        int nLinksRemoved = 0;
        Map<Individual, Set<Individual>> ancestors = PedigreeUtils.ancestorsMap(p);
        for (Pair<Individual, Individual> marriage : p.marriages()) {
            Set<Individual> a1;
            Set<Individual> a0 = ancestors.get(marriage.getFirst());
            if (!CollUtils.intersects(a0, a1 = ancestors.get(marriage.getSecond()))) continue;
            ++nLinksRemoved;
            PedigreeNode hNode0 = PedigreeNode.createHaplotypeNode(marriage.getFirst());
            PedigreeNode hNode1 = PedigreeNode.createHaplotypeNode(marriage.getSecond());
            PedigreeNode iNode0 = PedigreeNode.createInheritanceNode(marriage.getFirst());
            PedigreeNode iNode1 = PedigreeNode.createInheritanceNode(marriage.getSecond());
            if (g0.hasEdge(hNode0, iNode0)) {
                g0.removeEdge(hNode0, iNode0);
            }
            if (!g1.hasEdge(hNode1, iNode1)) continue;
            g1.removeEdge(hNode1, iNode1);
        }
        LogInfo.logs("Number of links removed:" + nLinksRemoved);
        if (!Graphs.isTree(g0)) {
            System.out.println("G0 is not a tree:");
            System.out.println(("" + Pedigree2FactorGraph.printACycle(g0)).replaceAll("[)],", "\n"));
        }
        if (!Graphs.isTree(g1)) {
            System.out.println("G1 is not a tree:");
            System.out.println(Pedigree2FactorGraph.printACycle(g1));
        }
        if (!Graphs.isTree(g0) || !Graphs.isTree(g1)) {
            throw new RuntimeException();
        }
        ArrayList<Graph<PedigreeNode>> result = new ArrayList<Graph<PedigreeNode>>(2);
        result.add(g0);
        result.add(g1);
        return result;
    }

    @Deprecated
    public static <V> List<V> printACycle(Graph<V> graph) {
        HashSet visited = new HashSet();
        return Pedigree2FactorGraph.printACycle(null, CollUtils.pick(graph.vertexSet()), graph, visited);
    }

    @Deprecated
    public static <V> List<V> printACycle(V caller, V current, Graph<V> graph, Set<V> visited) {
        if (visited.contains(current)) {
            return Collections.singletonList(current);
        }
        visited.add(current);
        List<V> tmp = null;
        for (V nbh : graph.nbrs(current)) {
            if (caller != null && caller.equals(nbh) || (tmp = Pedigree2FactorGraph.printACycle(current, nbh, graph, visited)) == null) continue;
            ArrayList<V> result = new ArrayList<V>();
            result.addAll(tmp);
            result.add(current);
            return result;
        }
        return null;
    }

    public static void addAlleleFactors(Pedigree p, FactorEncodings encs, MSFactorGraph<PedigreeNode> f) {
        for (Individual i : p.individuals()) {
            PedigreeNode haplotypeNode = PedigreeNode.createHaplotypeNode(i);
            for (int chrFrom = 0; chrFrom < 2; ++chrFrom) {
                PedigreeNode alleleNode = PedigreeNode.createAlleleNode(i, chrFrom);
                encs.addBinary(f, haplotypeNode, alleleNode, chrFrom);
            }
        }
    }

    public static void addAllelePresenceFactors(Pedigree p, FactorEncodings encs, MSFactorGraph<PedigreeNode> f) {
        for (Individual i : p.individuals()) {
            PedigreeNode haplotypeNode = PedigreeNode.createHaplotypeNode(i);
            for (int code = 0; code < 2; ++code) {
                PedigreeNode allelePresenceIndic = PedigreeNode.createAllelePresenceNode(i, code);
                encs.addBinary(f, haplotypeNode, allelePresenceIndic, code);
            }
        }
    }

    public static void addGenotypeFactors(Pedigree p, Genotypes genotypes, MSFactorGraph<PedigreeNode> f) {
        for (Individual i : p.individuals()) {
            PedigreeNode haplotypeNode = PedigreeNode.createHaplotypeNode(i);
            if (!genotypes.genotypedIndividuals().contains(i)) continue;
            Genotype genotype = genotypes.getGenotype(i);
            f.addUnary(haplotypeNode, genotype.getUnaryFactor());
        }
    }

    public static void addInheritanceFactors(RegularPedigree p, MSFactorGraph<PedigreeNode> f, FactorEncodings encodings) {
        for (Pair<Individual, Individual> marriage : p.marriages()) {
            List<Individual> children = p.children(marriage);
            if (children.size() == 1) {
                Pedigree2FactorGraph.processSingleChild(CollUtils.pick(children), marriage, f, encodings);
                continue;
            }
            Pedigree2FactorGraph.processMultipleChild(children, marriage, f, encodings);
        }
    }

    public static void addSimpleFounderFactors(RegularPedigree p, double[][] factor, MSFactorGraph<PedigreeNode> f) {
        for (Individual i : p.founders()) {
            f.addUnary(PedigreeNode.createHaplotypeNode(i), factor);
        }
    }

    public static void addIndependentRecombFactors(RegularPedigree p, MSFactorGraph<PedigreeNode> f, int genomeSize) {
        double[][] factor = new double[genomeSize][2];
        for (int i = 0; i < genomeSize; ++i) {
            for (int j = 0; j < 2; ++j) {
                factor[i][j] = 0.5;
            }
        }
        for (Individual i : p.individuals()) {
            if (p.founders().contains(i)) continue;
            for (int parent = 0; parent < 2; ++parent) {
                f.addUnary(PedigreeNode.createRecombNode(i, parent), factor);
            }
        }
    }

    public static double[][] getUniformHardyWeinbergDistribution(int nSites, FactorEncodings enc, double p) {
        double[] values = new double[enc.nHaplotypes()];
        for (int a0 = 0; a0 < 2; ++a0) {
            for (int a1 = 0; a1 < 2; ++a1) {
                values[enc.haplotypeCode((int[])new int[]{a0, a1})] = Pedigree2FactorGraph.hwHaplotype(a0, a1, p);
            }
        }
        return FactorUtils.simpleUnary(values, nSites);
    }

    public static double[][] getEstimatedHardWeinbergDistribution(Genotypes data) {
        double[][] result = new double[data.genomeSize()][];
        double[] ps = data.getFrequenciesOfZeroes();
        for (int site = 0; site < data.genomeSize(); ++site) {
            double[] values = new double[data.getFactorEncodings().nHaplotypes()];
            for (int a0 = 0; a0 < 2; ++a0) {
                for (int a1 = 0; a1 < 2; ++a1) {
                    values[data.getFactorEncodings().haplotypeCode((int[])new int[]{a0, a1})] = Pedigree2FactorGraph.hwHaplotype(a0, a1, ps[site]);
                }
            }
            result[site] = values;
        }
        return result;
    }

    public static double hwHaplotype(int a0, int a1, double freqForZero) {
        if (a0 >= 2 || a1 >= 2) {
            throw new RuntimeException();
        }
        if (a0 == a1 && a0 == 0) {
            return freqForZero * freqForZero;
        }
        if (a0 == a1 && a0 == 1) {
            return (1.0 - freqForZero) * (1.0 - freqForZero);
        }
        return freqForZero * (1.0 - freqForZero);
    }

    private static void processMultipleChild(List<Individual> children, Pair<Individual, Individual> marriage, MSFactorGraph<PedigreeNode> f, FactorEncodings encodings) {
        PedigreeNode marriageNode = PedigreeNode.createMarriageNode(marriage.getFirst(), marriage.getSecond());
        for (int parent = 0; parent < 2; ++parent) {
            PedigreeNode parentHaplo = PedigreeNode.createHaplotypeNode(parent == 0 ? marriage.getFirst() : marriage.getSecond());
            encodings.addBinary(f, marriageNode, parentHaplo, parent);
        }
        for (Individual child : children) {
            Pedigree2FactorGraph.processChild(child, f, encodings);
            PedigreeNode inhNode = PedigreeNode.createInheritanceNode(child);
            encodings.addBinary(f, marriageNode, inhNode);
        }
    }

    private static void processSingleChild(Individual child, Pair<Individual, Individual> marriage, MSFactorGraph<PedigreeNode> f, FactorEncodings encodings) {
        Pedigree2FactorGraph.processChild(child, f, encodings);
        PedigreeNode inhNode = PedigreeNode.createInheritanceNode(child);
        for (int parent = 0; parent < 2; ++parent) {
            PedigreeNode parentHaplo = PedigreeNode.createHaplotypeNode(parent == 0 ? marriage.getFirst() : marriage.getSecond());
            encodings.addBinary(f, parentHaplo, inhNode, parent);
        }
    }

    private static void processChild(Individual child, MSFactorGraph<PedigreeNode> f, FactorEncodings encodings) {
        PedigreeNode inhNode = PedigreeNode.createInheritanceNode(child);
        PedigreeNode hapNode = PedigreeNode.createHaplotypeNode(child);
        encodings.addBinary(f, inhNode, hapNode);
        for (int chrFrom = 0; chrFrom < 2; ++chrFrom) {
            PedigreeNode recombNode = PedigreeNode.createRecombNode(child, chrFrom);
            encodings.addBinary(f, inhNode, recombNode, chrFrom);
        }
    }

    public static void addDiseaseFactor(int genomeSize, MSFactorGraph<PedigreeNode> f, int number) {
        double[][] factor0 = new double[genomeSize][2];
        double epsilon = 1.0 / (double)genomeSize;
        for (int i = 0; i < genomeSize; ++i) {
            factor0[i][0] = 1.0 - epsilon;
            factor0[i][1] = epsilon;
        }
        f.addUnary(PedigreeNode.createDiseaseNode(0), factor0);
        if (number != 1) {
            if (number == 2) {
                double[][] factor1 = new double[genomeSize][2];
                for (int i = 0; i < genomeSize; ++i) {
                    for (int j = 0; j < 2; ++j) {
                        factor1[i][j] = 0.5;
                    }
                }
                f.addUnary(PedigreeNode.createDiseaseNode(1), factor1);
            } else {
                throw new RuntimeException();
            }
        }
    }
}

