/*
 * Decompiled with CFR 0.152.
 */
package pedi.factor;

import pedi.Individual;

public class PedigreeNode {
    private static final int UNASSIGNED = -1;
    public final Individual i;
    public final Individual i2;
    public final PedigreeNodeType type;
    public final int integerCode;

    public static PedigreeNode createInheritanceNode(Individual i) {
        return new PedigreeNode(i, PedigreeNodeType.INHERITANCE, -1, null);
    }

    public static PedigreeNode createMarriageNode(Individual father, Individual mother) {
        return new PedigreeNode(father, PedigreeNodeType.MARRIAGE, -1, mother);
    }

    public static PedigreeNode createAlleleNode(Individual i, int inheritedFrom) {
        return new PedigreeNode(i, PedigreeNodeType.ALLELE, inheritedFrom, null);
    }

    public static PedigreeNode createRecombNode(Individual i, int inheritedFrom) {
        return new PedigreeNode(i, PedigreeNodeType.RECOMB, inheritedFrom, null);
    }

    public static PedigreeNode createHaplotypeNode(Individual i) {
        return new PedigreeNode(i, PedigreeNodeType.HAPLOTYPE, -1, null);
    }

    public static PedigreeNode createAllelePresenceNode(Individual i, int code) {
        return new PedigreeNode(i, PedigreeNodeType.ALLELE_PRESENCE, code, null);
    }

    public static PedigreeNode createExternalNode(PedigreeNodeType type, int code) {
        return new PedigreeNode(null, type, code, null);
    }

    public static PedigreeNode createDiseaseNode(int code) {
        return PedigreeNode.createExternalNode(PedigreeNodeType.DISEASE, code);
    }

    public String toString() {
        return "" + (Object)((Object)this.type) + "(" + (this.i == null ? "" : " ind=" + this.i) + (this.i2 == null ? "" : " with=" + this.i2) + (this.integerCode == -1 ? "" : " code=" + this.integerCode) + " )";
    }

    private PedigreeNode(Individual i, PedigreeNodeType type, int inheritedFrom, Individual i2) {
        this.i2 = i2;
        this.i = i;
        this.type = type;
        this.integerCode = inheritedFrom;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.i == null ? 0 : this.i.hashCode());
        result = 31 * result + (this.i2 == null ? 0 : this.i2.hashCode());
        result = 31 * result + this.integerCode;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PedigreeNode other = (PedigreeNode)obj;
        if (this.i == null ? other.i != null : !this.i.equals(other.i)) {
            return false;
        }
        if (this.i2 == null ? other.i2 != null : !this.i2.equals(other.i2)) {
            return false;
        }
        if (this.integerCode != other.integerCode) {
            return false;
        }
        return this.type == other.type;
    }

    @Deprecated
    public static PedigreeNode createInheritanceNode(Individual i, int inheritedFrom) {
        return new PedigreeNode(i, PedigreeNodeType.INHERITANCE, inheritedFrom, null);
    }

    public static enum PedigreeNodeType {
        RECOMB,
        INHERITANCE,
        HAPLOTYPE,
        ALLELE,
        MARRIAGE,
        ALLELE_PRESENCE,
        DISEASE;

    }
}

