/*
 * Decompiled with CFR 0.152.
 */
package pedi.simulator;

import fig.basic.IOUtils;
import fig.exec.Execution;
import java.io.File;
import java.io.PrintWriter;
import java.util.Random;
import nuts.io.IO;
import nuts.math.Sampling;
import pedi.Genotypes;
import pedi.io.PedigreeFileReader;

public class DataSimulator {
    public static Genotypes simulateData(File recombRates, File founderHaplotypes, File inPedigreeFile, File outPedigreeFile, Random rand) {
        String cmd = "pedsim " + rand.nextInt(1000000) + " n 0.4 1 0 0 " + recombRates.getAbsolutePath() + " " + founderHaplotypes.getAbsolutePath() + " " + inPedigreeFile.getAbsolutePath() + " " + outPedigreeFile.getAbsolutePath();
        String resp = IO.call(cmd);
        IO.writeToDisk(new File(Execution.getFile("wf-generation-output")), resp);
        PedigreeFileReader reader = new PedigreeFileReader();
        reader.read(outPedigreeFile);
        return reader.getGenotypes();
    }

    public static void writeUniformRecombRateFile(File file, double rate, int nMarkers) {
        PrintWriter out = IOUtils.openOutEasy(file);
        for (int i = 0; i < nMarkers - 1; ++i) {
            out.print("" + rate + " ");
        }
        out.close();
    }

    public static void writeUniformFounderHaplotypes(File file, double frequency, int nFounders, int nSNPs, Random rand) {
        PrintWriter out = IOUtils.openOutEasy(file);
        for (int i = 0; i < nFounders; ++i) {
            for (int site = 0; site < nSNPs; ++site) {
                out.print("" + (Sampling.sampleBern(frequency, rand) ? 1 : 0) + " ");
            }
            out.println();
        }
        out.close();
    }
}

