/*
 * Decompiled with CFR 0.152.
 */
package pepper;

import fig.basic.IOUtils;
import fig.basic.Option;
import fig.basic.Pair;
import fig.exec.Execution;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pepper.CognateDetector;
import pepper.Corpus;

public class ConsolidateCorpus
implements Runnable {
    @Option(required=true)
    public ArrayList<String> sources;
    @Option(gloss="keep only those with editd/length < thr")
    public double threshold = 0.7;
    @Option
    public String outputPath = "/dev/stdout";
    private Set<String> langs = new HashSet<String>();
    private int consolidatedWordForms = Integer.MIN_VALUE;
    private List<String> sortedFieldNames = null;

    public ConsolidateCorpus(ArrayList<String> sources, double threshold) {
        this.sources = sources;
        this.threshold = threshold;
    }

    public ConsolidateCorpus() {
    }

    public static void main(String[] args) throws IOException {
        Execution.startMainTrack = false;
        Execution.run(args, new ConsolidateCorpus());
    }

    @Override
    public void run() {
        try {
            this.printCorpus(this.consolidate(), IOUtils.openOut(this.outputPath));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int getNConsolidatedWordForms() {
        return this.consolidatedWordForms;
    }

    public Set<List<String>> consolidate() throws IOException {
        this.consolidatedWordForms = 0;
        HashSet<List<String>> result = new HashSet<List<String>>();
        Map<Pair<String, String>, Set<Pair<String, String>>> relation = this.getRelations(this.sources, this.threshold);
        TransitiveCloser<Pair<String, String>> closer = new TransitiveCloser<Pair<String, String>>(relation);
        List<Set<Pair<String, String>>> ccs = closer.connectedComponents();
        for (Set<Pair<String, String>> cc : ccs) {
            List<String> current = this.pickBestCognates(cc, 0).getSecond();
            int nUnk = Collections.frequency(current, "?");
            if (nUnk > current.size() - 2) continue;
            result.add(current);
            this.consolidatedWordForms = this.consolidatedWordForms + current.size() - nUnk;
        }
        return result;
    }

    private void printCorpus(Set<List<String>> data, PrintWriter out) {
        out.println(this.header());
        for (List<String> line : data) {
            for (String word : line) {
                out.print(word + " ");
            }
            out.print("\n");
        }
        out.close();
    }

    public StringBuilder header() {
        StringBuilder out = new StringBuilder();
        out.append("# ");
        for (String field : this.getSortedFieldNames()) {
            out.append(field + " ");
        }
        return out;
    }

    private Map<Pair<String, String>, Set<Pair<String, String>>> getRelations(List<String> file, double threshold) throws IOException {
        HashMap<Pair<String, String>, Set<Pair<String, String>>> relation = new HashMap<Pair<String, String>, Set<Pair<String, String>>>();
        for (String currentFile : file) {
            Corpus currentCorpus = Corpus.parse(currentFile);
            for (int row = 0; row < currentCorpus.getNWords(); ++row) {
                for (int src = 0; src < currentCorpus.getNLangs(); ++src) {
                    for (int dest = 0; dest < currentCorpus.getNLangs(); ++dest) {
                        String srcW = currentCorpus.getWord(row, src);
                        String destW = currentCorpus.getWord(row, dest);
                        String srcFN = currentCorpus.getFieldNames().get(src);
                        this.langs.add(srcFN);
                        String destFN = currentCorpus.getFieldNames().get(dest);
                        if (srcW == null || destW == null || CognateDetector.averageEditD(srcW, destW) > threshold) continue;
                        Pair<String, String> srcKey = new Pair<String, String>(srcFN, srcW);
                        Pair<String, String> destKey = new Pair<String, String>(destFN, destW);
                        HashSet<Pair<String, String>> nbrs = (HashSet<Pair<String, String>>)relation.get(srcKey);
                        if (nbrs == null) {
                            nbrs = new HashSet<Pair<String, String>>();
                            relation.put(srcKey, nbrs);
                        }
                        nbrs.add(destKey);
                    }
                }
            }
        }
        return relation;
    }

    public List<String> getSortedFieldNames() {
        if (this.sortedFieldNames != null) {
            return this.sortedFieldNames;
        }
        this.sortedFieldNames = new ArrayList<String>();
        this.sortedFieldNames.addAll(this.langs);
        Collections.sort(this.sortedFieldNames);
        return this.sortedFieldNames;
    }

    public int nFields() {
        return this.langs.size();
    }

    private Pair<Double, List<String>> pickBestCognates(Set<Pair<String, String>> cc, int currentIndex) {
        if (currentIndex >= this.langs.size()) {
            return new Pair<Double, List<String>>(0.0, new ArrayList());
        }
        ArrayList<String> currentArgMin = null;
        double currentMin = Double.POSITIVE_INFINITY;
        for (Pair<String, String> wordForm : cc) {
            if (!wordForm.getFirst().equals(this.getSortedFieldNames().get(currentIndex))) continue;
            Pair<Double, List<String>> recursion = this.pickBestCognates(cc, currentIndex + 1);
            double currentScore = recursion.getFirst();
            for (String recWord : recursion.getSecond()) {
                if (recWord.equals("?")) continue;
                currentScore += CognateDetector.averageEditD(recWord, wordForm.getSecond());
            }
            if (!(currentScore < currentMin)) continue;
            currentMin = currentScore;
            currentArgMin = new ArrayList();
            currentArgMin.add(wordForm.getSecond());
            currentArgMin.addAll((Collection)recursion.getSecond());
        }
        if (currentArgMin == null) {
            Pair<Double, List<String>> recursion = this.pickBestCognates(cc, currentIndex + 1);
            currentMin = recursion.getFirst();
            currentArgMin = new ArrayList<String>();
            currentArgMin.add("?");
            currentArgMin.addAll((Collection)recursion.getSecond());
        }
        return new Pair<Double, Object>(currentMin, currentArgMin);
    }

    public static class TransitiveCloser<T> {
        private Map<T, Set<T>> relations;

        public TransitiveCloser(Map<T, Set<T>> relations) {
            this.relations = relations;
        }

        private T pop(Set<T> set) {
            T result = set.iterator().next();
            set.remove(result);
            return result;
        }

        public List<Set<T>> connectedComponents() {
            ArrayList<Set<T>> result = new ArrayList<Set<T>>();
            HashSet<T> remainingNodes = new HashSet<T>();
            remainingNodes.addAll(this.relations.keySet());
            while (!remainingNodes.isEmpty()) {
                HashSet currentCC = new HashSet();
                HashSet<Object> currentFringe = new HashSet<Object>();
                currentFringe.add(this.pop(remainingNodes));
                while (!currentFringe.isEmpty()) {
                    Object current = this.pop(currentFringe);
                    currentCC.add(current);
                    for (T nbhr : this.relations.get(current)) {
                        if (currentCC.contains(nbhr)) continue;
                        remainingNodes.remove(nbhr);
                        currentFringe.add(nbhr);
                    }
                }
                result.add(currentCC);
            }
            return result;
        }
    }
}

