/*
 * Decompiled with CFR 0.152.
 */
package pepper;

import fig.basic.CharEncUtils;
import fig.basic.IOUtils;
import fig.basic.Indexer;
import fig.basic.ListUtils;
import fig.basic.Option;
import fig.exec.Execution;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import pepper.PhonemeEqClass;
import pepper.PhonemesFile;
import pepper.editmodel.Utils;

public final class Encodings
implements Serializable {
    private static final long serialVersionUID = -3061385419614399424L;
    @Option
    public static EncodingType encodingsType = EncodingType.REAL;
    private static Encodings globalEncodings = null;
    @Option
    public static int toyEncodingsSize = 2;
    public static Character[] AMINO_ACIDS = new Character[]{Character.valueOf('a'), Character.valueOf('r'), Character.valueOf('n'), Character.valueOf('d'), Character.valueOf('c'), Character.valueOf('q'), Character.valueOf('e'), Character.valueOf('g'), Character.valueOf('h'), Character.valueOf('i'), Character.valueOf('l'), Character.valueOf('k'), Character.valueOf('m'), Character.valueOf('f'), Character.valueOf('p'), Character.valueOf('s'), Character.valueOf('t'), Character.valueOf('w'), Character.valueOf('y'), Character.valueOf('v')};
    public static final Set<Character> HYDROPHILIC = new HashSet<Character>(Arrays.asList(Character.valueOf('D'), Character.valueOf('E'), Character.valueOf('G'), Character.valueOf('K'), Character.valueOf('N'), Character.valueOf('Q'), Character.valueOf('P'), Character.valueOf('R'), Character.valueOf('S')));
    public static final char A = 'A';
    public static final char C = 'C';
    public static final char G = 'G';
    public static final char T = 'T';
    public static final char U = 'U';
    public static Character[] RNA = new Character[]{Character.valueOf('A'), Character.valueOf('C'), Character.valueOf('G'), Character.valueOf('U')};
    public static Character[] DNA = new Character[]{Character.valueOf('A'), Character.valueOf('C'), Character.valueOf('G'), Character.valueOf('T')};
    public static final char BNDRY_SMBL = '#';
    @Option(gloss="Where is the consonants file")
    public static String ipaConsonantsFile = "/Users/bouchard/Documents/workspace/pepper/encodings/converted-cons.ipa";
    @Option(gloss="Which fields in consonants to use")
    public static ArrayList<Integer> consonantIndices = ListUtils.newList(1, 2, 3, 4, 5, 6);
    @Option(gloss="Where is the vowel file")
    public static String ipaVowelsFile = "/Users/bouchard/Documents/workspace/pepper/encodings/converted-vow.ipa";
    @Option(gloss="Which fields in vowels to use")
    public static ArrayList<Integer> vowelsIndices = ListUtils.newList(1, 2, 3, 4);
    private Indexer<Character> phonemeIndexer;
    private Indexer<PhonemeEqClass> eqClassIndexer;
    private int[] phoneId2EqClassIdMap;
    private char boundarySymbol;
    private int cachedBoundaryPhoneId;
    private int cachedBoundaryEqClassId;

    public Encodings() {
        for (int i = 0; i < AMINO_ACIDS.length; ++i) {
            Encodings.AMINO_ACIDS[i] = Character.valueOf(Character.toUpperCase(AMINO_ACIDS[i].charValue()));
        }
        this.cachedBoundaryPhoneId = -1;
        this.cachedBoundaryEqClassId = -1;
    }

    public nuts.util.Indexer<Character> nonGapCharactersIndexer() {
        nuts.util.Indexer<Character> result = new nuts.util.Indexer<Character>();
        for (int index = 0; index < this.N(); ++index) {
            if (this.boundId() == index) continue;
            result.addToIndex((Character[])new Character[]{Character.valueOf(this.phoneId2Char(index))});
        }
        if (result.size() != this.N() - 1) {
            throw new RuntimeException();
        }
        return result;
    }

    public static Encodings getGlobalEncodings() {
        return globalEncodings;
    }

    public static void registerEncodings(Encodings enc) {
        if (enc == null) {
            throw new RuntimeException("Cant register null encs");
        }
        if (globalEncodings == null) {
            globalEncodings = enc;
        } else if (!globalEncodings.equals(enc)) {
            throw new RuntimeException("Conflicting calls of registerEncodings");
        }
    }

    public static void resetGlobalEncodings() {
        globalEncodings = null;
    }

    public static Encodings toyEncodings() {
        Encodings result = new Encodings();
        result.phonemeIndexer = new Indexer<Character>(ListUtils.newList(Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('#')));
        PhonemeEqClass A = new PhonemeEqClass("A");
        PhonemeEqClass BC = new PhonemeEqClass("BC");
        PhonemeEqClass boundEqClass = new PhonemeEqClass("#");
        result.eqClassIndexer = new Indexer<PhonemeEqClass>(ListUtils.newList(A, BC, boundEqClass));
        result.phoneId2EqClassIdMap = new int[result.getNumberOfPhonemes()];
        Encodings.assign('a', A, result);
        Encodings.assign('b', BC, result);
        Encodings.assign('c', BC, result);
        Encodings.assign('#', boundEqClass, result);
        result.boundarySymbol = (char)35;
        return result;
    }

    public static Encodings toyCtxFreeEncodings() {
        return Encodings.toyCtxFreeEncodings(toyEncodingsSize);
    }

    public static Encodings toyCtxFreeEncodings(int n) {
        if (n > 26) {
            throw new RuntimeException("Can be fixed error in toyCtxFreeEnc");
        }
        ArrayList<Character> chars = new ArrayList<Character>();
        for (int i = 0; i < n; ++i) {
            chars.add(Character.valueOf((char)(97 + i)));
        }
        return Encodings.ctxFreeEncodings(chars);
    }

    public static Encodings proteinEncodings() {
        return Encodings.proteinEncodings(true);
    }

    public static Encodings proteinEncodings(boolean useOnly20) {
        if (!useOnly20) {
            throw new RuntimeException();
        }
        Character[] symbols = new Character[]{Character.valueOf('A'), Character.valueOf('R'), Character.valueOf('N'), Character.valueOf('D'), Character.valueOf('C'), Character.valueOf('Q'), Character.valueOf('E'), Character.valueOf('G'), Character.valueOf('H'), Character.valueOf('L'), Character.valueOf('I'), Character.valueOf('K'), Character.valueOf('M'), Character.valueOf('F'), Character.valueOf('P'), Character.valueOf('S'), Character.valueOf('T'), Character.valueOf('W'), Character.valueOf('Y'), Character.valueOf('V'), Character.valueOf('B'), Character.valueOf('Z'), Character.valueOf('X')};
        return Encodings.ctxFreeEncodings(Arrays.asList(useOnly20 ? AMINO_ACIDS : symbols));
    }

    public static Encodings dnaEncodings() {
        return Encodings.ctxFreeEncodings(Arrays.asList(DNA));
    }

    public static Encodings rnaEncodings() {
        return Encodings.ctxFreeEncodings(Arrays.asList(RNA));
    }

    public static Encodings ctxFreeEncodings(Collection<Character> symbols) {
        Encodings result = new Encodings();
        ArrayList<Character> chars = new ArrayList<Character>();
        for (char c : symbols) {
            chars.add(Character.valueOf(c));
        }
        chars.add(Character.valueOf('#'));
        result.phonemeIndexer = new Indexer(chars);
        PhonemeEqClass wildCard = new PhonemeEqClass("*");
        result.eqClassIndexer = new Indexer<PhonemeEqClass>(ListUtils.newList(wildCard));
        result.phoneId2EqClassIdMap = new int[result.getNumberOfPhonemes()];
        Iterator iterator = chars.iterator();
        while (iterator.hasNext()) {
            char aChar = ((Character)iterator.next()).charValue();
            Encodings.assign(aChar, wildCard, result);
        }
        result.boundarySymbol = (char)35;
        return result;
    }

    public static Encodings getEncoding(EncodingType type) throws IOException {
        if (type == EncodingType.REAL) {
            return Encodings.realEncoding();
        }
        if (type == EncodingType.TOY_CTX_FREE) {
            return Encodings.toyCtxFreeEncodings(4);
        }
        if (type == EncodingType.PROTEIN) {
            throw new RuntimeException("Protein unsup?");
        }
        throw new RuntimeException("Unsup enc");
    }

    public static Encodings realEncoding(Set<Character> occurring) throws IOException {
        Encodings result = new Encodings();
        ArrayList<Character> characters = new ArrayList<Character>();
        for (char c : Encodings.allCharsInRealEnc()) {
            if (!occurring.contains(Character.valueOf(c))) continue;
            characters.add(Character.valueOf(c));
        }
        characters.add(Character.valueOf('#'));
        result.boundarySymbol = (char)35;
        result.phonemeIndexer = new Indexer(characters);
        result.phoneId2EqClassIdMap = new int[result.getNumberOfPhonemes()];
        result.eqClassIndexer = new Indexer();
        Encodings.createEqClasses(ipaConsonantsFile, consonantIndices, occurring, result);
        Encodings.createEqClasses(ipaVowelsFile, vowelsIndices, occurring, result);
        PhonemeEqClass boundEqClass = new PhonemeEqClass("#");
        Encodings.assign('#', boundEqClass, result);
        return result;
    }

    public static Encodings realEncoding() throws IOException {
        return Encodings.realEncoding(Encodings.allCharsInRealEnc());
    }

    public Set<Character> allChars() {
        HashSet<Character> result = new HashSet<Character>();
        for (int id = 0; id < this.getNumberOfPhonemes(); ++id) {
            result.add(Character.valueOf(this.phoneId2Char(id)));
        }
        return result;
    }

    public static Set<Character> allCharsInRealEnc() throws IOException {
        HashSet<Character> allCharacters = new HashSet<Character>();
        Encodings.addAllCharacters(ipaConsonantsFile, allCharacters);
        Encodings.addAllCharacters(ipaVowelsFile, allCharacters);
        return allCharacters;
    }

    public static void addAllCharacters(String eqClassFile, Set<Character> allCharacters) throws IOException {
        if (eqClassFile == null) {
            return;
        }
        ArrayList eqClasses = new ArrayList();
        BufferedReader in = IOUtils.openIn(eqClassFile);
        String line = null;
        while ((line = in.readLine()) != null) {
            String[] fields = line.split("\\s+|\\t+");
            char currentCharacter = fields[0].charAt(0);
            allCharacters.add(Character.valueOf(currentCharacter));
        }
        in.close();
    }

    public static void createEqClasses(String eqClassFile, List<Integer> indices, Set<Character> occurring, Encodings enc) throws IOException {
        if (eqClassFile == null) {
            return;
        }
        PhonemesFile phonemesFile = PhonemesFile.load(eqClassFile);
        for (char currentCharacter : phonemesFile) {
            if (!occurring.contains(Character.valueOf(currentCharacter))) continue;
            ArrayList<String> stringRep = new ArrayList<String>();
            for (int i = 0; i < indices.size(); ++i) {
                int index = indices.get(i);
                stringRep.add(phonemesFile.getField(currentCharacter, index - 1));
            }
            PhonemeEqClass eq = new PhonemeEqClass(stringRep);
            Encodings.assign(currentCharacter, eq, enc);
        }
    }

    public static void assign(char character, PhonemeEqClass eqClass, Encodings enc) {
        int eqClassId;
        int phoneId = enc.char2PhoneId(character);
        enc.phoneId2EqClassIdMap[phoneId] = eqClassId = enc.eqClassIndexer.getIndex(eqClass);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Encodings)) {
            return false;
        }
        Encodings other = (Encodings)obj;
        if (!Encodings.equals(other.phonemeIndexer, this.phonemeIndexer)) {
            return false;
        }
        if (!Encodings.equals(other.eqClassIndexer, this.eqClassIndexer)) {
            return false;
        }
        if (other.boundarySymbol != this.boundarySymbol) {
            return false;
        }
        return Arrays.equals(this.phoneId2EqClassIdMap, other.phoneId2EqClassIdMap);
    }

    private static boolean equals(Indexer i1, Indexer i2) {
        return i1.getObjects().equals(i2.getObjects());
    }

    public int[] string2PhoneIds(String phonemes) {
        int[] code = new int[phonemes.length()];
        for (int i = 0; i < phonemes.length(); ++i) {
            code[i] = this.char2PhoneId(phonemes.charAt(i));
        }
        return code;
    }

    public int char2PhoneId(char phoneme) {
        return this.phonemeIndexer.indexOf(Character.valueOf(phoneme));
    }

    public char phoneId2Char(int integerCode) {
        return this.phonemeIndexer.getObject(integerCode).charValue();
    }

    public int getNumberOfPhonemes() {
        return this.phonemeIndexer.size();
    }

    public int N() {
        return this.getNumberOfPhonemes();
    }

    public int phoneId2EqClassId(int c) {
        return this.phoneId2EqClassIdMap[c];
    }

    public int char2EqClassId(char phoneme) {
        return this.phoneId2EqClassIdMap[this.char2PhoneId(phoneme)];
    }

    public String getEqClassDescription(int code) {
        return this.retrieveEqClass(code).toString();
    }

    public PhonemeEqClass phoneId2EqClassObject(int phoneId) {
        return this.eqClassIndexer.getObject(this.phoneId2EqClassId(phoneId));
    }

    public PhonemeEqClass retrieveEqClass(int eqClassId) {
        return this.eqClassIndexer.getObject(eqClassId);
    }

    public int getEqClassIndex(PhonemeEqClass eqClass) {
        return this.eqClassIndexer.indexOf(eqClass);
    }

    public int getNumberOfEqClasses() {
        return this.eqClassIndexer.size();
    }

    public int getBoundaryPhoneId() {
        if (this.cachedBoundaryPhoneId != -1) {
            return this.cachedBoundaryPhoneId;
        }
        this.cachedBoundaryPhoneId = this.char2PhoneId(this.boundarySymbol);
        return this.cachedBoundaryPhoneId;
    }

    public int boundId() {
        return this.getBoundaryPhoneId();
    }

    public char boundChar() {
        return this.boundarySymbol;
    }

    public int getBoundaryEqClassId() {
        if (this.cachedBoundaryEqClassId != -1) {
            return this.cachedBoundaryEqClassId;
        }
        this.cachedBoundaryEqClassId = this.phoneId2EqClassId(this.getBoundaryPhoneId());
        return this.cachedBoundaryEqClassId;
    }

    public int topc(String s, int index) {
        return index >= 0 && index < s.length() ? this.x2c(this.char2PhoneId(s.charAt(index))) : this.getBoundaryEqClassId();
    }

    public int x2c(int x) {
        return this.phoneId2EqClassId(x);
    }

    public int idAt(String word, int position) {
        if (position < 0 || position >= word.length()) {
            return this.boundId();
        }
        return this.char2PhoneId(word.charAt(position));
    }

    public char charAt(String word, int position) {
        if (position < 0 || position >= word.length()) {
            return this.boundChar();
        }
        return word.charAt(position);
    }

    public static void main(String[] args) throws IOException {
        Execution.init(args, "encodings", Encodings.class);
        Encodings enc = Encodings.realEncoding();
        System.out.println();
        PrintWriter out = CharEncUtils.getWriter(System.out);
        out.println(enc.toString());
        Execution.finish();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (int x = 0; x < this.getNumberOfPhonemes(); ++x) {
            PhonemeEqClass c = this.retrieveEqClass(this.phoneId2EqClassId(x));
            builder.append("" + this.phoneId2Char(x) + " : " + c.toString() + "\n");
        }
        return builder.toString();
    }

    public static void saveEncodingsInExec(Encodings enc, String prefix) {
        String fileName = prefix + ".Encodings";
        try {
            Encodings.saveEncodings(enc, Utils.safeGetExecFilePath(fileName));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void saveEncodings(Encodings enc, String file) throws IOException {
        ObjectOutputStream oos = IOUtils.openBinOut(file);
        oos.writeObject(enc);
        oos.close();
    }

    public static Encodings restoreEncodings(String filePath) {
        try {
            ObjectInputStream ois = IOUtils.openBinIn(filePath);
            return (Encodings)ois.readObject();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static enum EncodingType {
        REAL,
        TOY_CTX_FREE,
        PROTEIN,
        RNA,
        DNA;

    }
}

