/*
 * Decompiled with CFR 0.152.
 */
package pepper;

import fig.basic.StrUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class PhonemeEqClass
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<String> description = new ArrayList<String>();
    private static final String delimiter = "-";
    private static final String NA = "NA";
    public static final List<PhonemeFeatureTypes> vowelFeatureTypes = PhonemeEqClass.allFeatureTypes(true);
    public static final List<PhonemeFeatureTypes> consFeatureTypes = PhonemeEqClass.allFeatureTypes(false);
    private String stringRep = null;

    public PhonemeEqClass(List<String> rep) {
        this.description.addAll(rep);
        this.description = Collections.unmodifiableList(this.description);
    }

    public PhonemeEqClass(String stringRep) {
        this(Arrays.asList(stringRep.split(delimiter)));
    }

    public List<String> getDescription() {
        return this.description;
    }

    public boolean isVowel() {
        if (this.getDescription().contains("vowel")) {
            return true;
        }
        if (this.getDescription().contains("consonant")) {
            return false;
        }
        throw new RuntimeException();
    }

    public String getFeature(PhonemeFeatureTypes featureType) {
        if (featureType.forVowels != this.isVowel()) {
            throw new RuntimeException("Vow/cons dont match in getFeature");
        }
        if (featureType.indexInFile >= this.getDescription().size()) {
            return NA;
        }
        return this.getDescription().get(featureType.indexInFile);
    }

    private static List<PhonemeFeatureTypes> allFeatureTypes(boolean forVowels) {
        ArrayList<PhonemeFeatureTypes> result = new ArrayList<PhonemeFeatureTypes>();
        for (PhonemeFeatureTypes pft : PhonemeFeatureTypes.values()) {
            if (pft.forVowels != forVowels) continue;
            result.add(pft);
        }
        return Collections.unmodifiableList(result);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof PhonemeEqClass)) {
            return false;
        }
        PhonemeEqClass o_cast = (PhonemeEqClass)o;
        return !(this.description != null ? !this.description.equals(o_cast.description) : o_cast.description != null);
    }

    public int hashCode() {
        int hashCode = this.description != null ? this.description.hashCode() : 0;
        return hashCode;
    }

    public String toString() {
        if (this.stringRep == null) {
            this.stringRep = StrUtils.join(this.description, delimiter);
        }
        return this.stringRep;
    }

    public static enum PhonemeFeatureTypes {
        PLACE(0, false),
        MANNER(1, false),
        PHONATION(2, false),
        NASALNESS(3, false),
        LATERALNESS(4, false),
        ROUNDEDNESS(0, true),
        BACKNESS(1, true),
        HEIGHT(2, true),
        LABIALIZATION(6, false),
        ASPIRATION(7, false);

        public final int indexInFile;
        public final boolean forVowels;

        private PhonemeFeatureTypes(int index, boolean forVowels) {
            this.indexInFile = index;
            this.forVowels = forVowels;
        }
    }
}

