/*
 * Decompiled with CFR 0.152.
 */
package pepper.editmodel;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import nuts.maxent.BaseMeasures;
import pepper.Edit;
import pepper.Effect;
import pepper.Environment;

public class HeterogeneousBaseMeasure<I, L>
implements BaseMeasures<I, L> {
    private Map<I, SortedSet<L>> baseMeasures = new HashMap<I, SortedSet<L>>();

    private HeterogeneousBaseMeasure() {
    }

    @Override
    public SortedSet<L> support(I input) {
        if (this.baseMeasures.get(input) == null) {
            throw new RuntimeException();
        }
        return Collections.unmodifiableSortedSet(this.baseMeasures.get(input));
    }

    public static HeterogeneousBaseMeasure<Environment, Effect> baseMeasureFromAllowedRules(Collection<Edit> rules) {
        HeterogeneousBaseMeasure<Environment, Effect> result = new HeterogeneousBaseMeasure<Environment, Effect>();
        for (Edit edit : rules) {
            Environment env = edit.getEnvironment();
            Effect eff = edit.getEffect();
            SortedSet baseMeasure = result.baseMeasures.get(env);
            if (baseMeasure == null) {
                baseMeasure = new TreeSet();
                result.baseMeasures.put(env, baseMeasure);
            }
            baseMeasure.add(eff);
        }
        return result;
    }
}

