/*
 * Decompiled with CFR 0.152.
 */
package pepper.editmodel;

import fig.basic.LogInfo;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import nuts.maxent.BaseMeasures;
import nuts.maxent.FeatureExtractor;
import nuts.maxent.LabeledInstance;
import nuts.maxent.MaxentClassifier;
import nuts.util.Counter;
import nuts.util.MathUtils;
import pepper.Edit;
import pepper.Effect;
import pepper.Encodings;
import pepper.Environment;
import pepper.editmodel.EditParam;
import pepper.editmodel.HeterogeneousBaseMeasure;
import pepper.editmodel.ParamUpdater;
import pepper.editmodel.features.CutoffFeaturesExtractor;

public class MaxentParamUpdater<F>
implements ParamUpdater.LanguageSpecificParamUpdater {
    private static final long serialVersionUID = 1L;
    private final Encodings enc;
    private BaseMeasures<Environment, Effect> mu;
    private double sigma = 1.0;
    private Set<Edit> allowedEdits = new HashSet<Edit>();
    private FeatureExtractor<LabeledInstance<Environment, Effect>, F> featureExtractor;
    private MaxentClassifier<Environment, Effect, F> classifier;
    private final int iterations;
    private final double tolerance;
    private double cutoff;
    private Counter<F> currentWeights = new Counter();

    public MaxentParamUpdater(Encodings enc, Collection<Edit> rules, FeatureExtractor<LabeledInstance<Environment, Effect>, F> featureExtractor, double sigma, int iterations, double tolerance, double cutoff) {
        this.enc = enc;
        this.sigma = sigma;
        this.tolerance = tolerance;
        this.iterations = iterations;
        this.cutoff = cutoff;
        this.mu = HeterogeneousBaseMeasure.baseMeasureFromAllowedRules(rules);
        this.allowedEdits.addAll(rules);
        this.allowedEdits = Collections.unmodifiableSet(this.allowedEdits);
        this.featureExtractor = featureExtractor;
    }

    @Override
    public void setSparsityStructure(Set<Edit> allowedEdits) {
        this.allowedEdits = new HashSet<Edit>();
        this.allowedEdits.addAll(allowedEdits);
        this.mu = HeterogeneousBaseMeasure.baseMeasureFromAllowedRules(allowedEdits);
    }

    @Override
    public Encodings getEncodings() {
        return this.enc;
    }

    @Override
    public ParamUpdater.LanguageSpecificParamUpdater newInstance() {
        return new MaxentParamUpdater<F>(this.enc, this.allowedEdits, this.featureExtractor, this.sigma, this.iterations, this.tolerance, this.cutoff);
    }

    @Override
    public Set<Edit> getSparsityStructure() {
        return this.allowedEdits;
    }

    @Override
    public EditParam update(Counter<Edit> expectedEditCounts, boolean viterbi) {
        if (!viterbi) {
            throw new UnsupportedOperationException();
        }
        Counter<LabeledInstance<Environment, Effect>> training = MaxentParamUpdater.convertCounts(expectedEditCounts);
        if (this.cutoff > 0.0) {
            this.featureExtractor = CutoffFeaturesExtractor.createCutOffFeaturesExtractor(this.cutoff, this.featureExtractor, training);
        }
        LogInfo.track("Learning maxent model from the sampled edits");
        Object learningOptions = null;
        throw new RuntimeException();
    }

    public String toString() {
        if (this.classifier == null) {
            return "MaxentParamUpdater: Not yet utilized";
        }
        return this.classifier.toString();
    }

    private <F> EditParam fillEditParam(final MaxentClassifier<Environment, Effect, F> classifier) {
        return EditParam.createEditParam(this.enc, new EditParam.Initializer(){

            @Override
            public void process() {
                for (Environment env : Edit.allEnvironments(MaxentParamUpdater.this.enc)) {
                    double[] prs = MathUtils.exp(classifier.logProb(env));
                    SortedSet effects = classifier.getLabels(env);
                    int i = 0;
                    for (Effect eff : effects) {
                        this.set(new Edit(MaxentParamUpdater.this.enc, env, eff), prs[i]);
                        ++i;
                    }
                }
            }
        });
    }

    private static Counter<LabeledInstance<Environment, Effect>> convertCounts(Counter<Edit> src) {
        Counter<LabeledInstance<Environment, Effect>> result = new Counter<LabeledInstance<Environment, Effect>>();
        for (Edit srcCount : src.keySet()) {
            Environment env = srcCount.getEnvironment();
            Effect effect = srcCount.getEffect();
            LabeledInstance<Environment, Effect> labeledInstance = new LabeledInstance<Environment, Effect>(effect, env);
            assert (result.getCount(labeledInstance) == 0.0);
            result.setCount(labeledInstance, src.getCount(srcCount));
        }
        return result;
    }
}

