/*
 * Decompiled with CFR 0.152.
 */
package pepper.editmodel;

import fig.basic.IOUtils;
import fig.exec.Execution;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import pepper.Edit;
import pepper.Encodings;
import pepper.editmodel.ParamUpdater;

public class Utils {
    public static String bottomWord(List<Edit> edits) {
        StringBuilder result = new StringBuilder();
        for (Edit edit : edits) {
            Encodings enc = edit.getEncodings();
            if (edit.isFission()) {
                result.append("" + enc.phoneId2Char(edit.y) + enc.phoneId2Char(edit.z));
                continue;
            }
            if (!edit.isSubstitution()) continue;
            result.append("" + enc.phoneId2Char(edit.y));
        }
        return result.toString();
    }

    public static String topWord(List<Edit> edits) {
        StringBuilder result = new StringBuilder();
        for (Edit edit : edits) {
            Encodings enc = edit.getEncodings();
            result.append("" + enc.phoneId2Char(edit.x));
        }
        return result.toString();
    }

    public static String safeGetExecFilePath(String fileName) {
        String result = Execution.getFile(fileName);
        if (result == null) {
            return fileName;
        }
        return result;
    }

    public static void saveParamUpdater(ParamUpdater upd, String filePath) throws IOException {
        ObjectOutputStream oos = IOUtils.openBinOut(filePath);
        oos.writeObject(upd);
        oos.close();
    }

    public static ParamUpdater restoreParamUpdater(String filePath) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = IOUtils.openBinIn(filePath);
        return (ParamUpdater)ois.readObject();
    }
}

