/*
 * Decompiled with CFR 0.152.
 */
package practice;

import ev.hmm.HetPairHMM;
import ev.hmm.HomogenousHMM;
import ev.par.ExponentialFamily;
import ev.par.FeatureExtractor;
import goblin.DerivationTree;
import goblin.Taxon;
import java.util.Random;
import ma.SequenceType;
import nuts.maxent.MaxentClassifier;
import nuts.maxent.SloppyMath;
import pepper.Encodings;

public class Test {
    public static void main(String[] args) {
        HomogenousHMM hmm = new HomogenousHMM(Encodings.toyCtxFreeEncodings(), 1, 0, 0);
        String[] top = new String[]{"gumbo", "gamba"};
        String[] bot = new String[]{"guo", "gba"};
        ExponentialFamily.ExponentialFamilyOptions opt = new ExponentialFamily.ExponentialFamilyOptions();
        opt.encodingType = SequenceType.PHONEMES;
        FeatureExtractor.FeatureOptions fopt = new FeatureExtractor.FeatureOptions();
        fopt.hydrophobicModeling = false;
        ExponentialFamily fam = ExponentialFamily.createExpfam(new MaxentClassifier.MaxentOptions<Object>(), opt, fopt, null);
        Taxon lang1 = new Taxon("language1");
        Taxon lang2 = new Taxon("language2");
        HetPairHMM hh = null;
        for (int j = 0; j < 1; ++j) {
            double loglik = Double.NEGATIVE_INFINITY;
            for (int k = 0; k < 1; ++k) {
                for (int i = 0; i < 5; ++i) {
                    hh = fam.getHMM(top[j], bot[k], lang1, lang2);
                    fam.addSufficientStatistics(hh, lang1, lang2);
                    DerivationTree.Derivation deriv = hh.sample(new Random(1L));
                    System.out.println(deriv.toString());
                    double logp = 0.0;
                    for (int x = 0; x < hh.str1.length(); ++x) {
                        for (int y = 0; y < hh.str2.length(); ++y) {
                            double p = hh.logPosteriorAlignment(x, y);
                            logp = SloppyMath.logAdd(logp, p);
                        }
                    }
                    System.out.println(logp);
                    System.out.println(logp -= hh.logSumProduct());
                    fam.updateParameters();
                }
                DerivationTree.Derivation deriv = hh.sample(new Random());
                System.out.println(deriv.toString());
            }
        }
    }
}

