/*
 * Decompiled with CFR 0.152.
 */
package pty;

import fig.basic.IOUtils;
import fig.basic.LogInfo;
import fig.basic.StrUtils;
import fig.exec.Execution;
import goblin.Taxon;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import nuts.math.GMFct;
import nuts.util.Arbre;
import pty.Train;
import pty.eval.SymmetricDiff;
import pty.io.Dataset;
import pty.io.HGDPDataset;
import pty.learn.CTMCLoader;
import pty.learn.DiscreteBP;
import pty.smc.PartialCoalescentState;
import pty.smc.ParticleFilter;
import pty.smc.PriorPriorKernel;
import pty.smc.models.CTMC;
import pty.smc.models.CTMCUtils;

public class ProcessPops
implements Runnable {
    private static ParticleFilter<PartialCoalescentState> pf;
    private static CTMCLoader loader;

    @Override
    public void run() {
        HashMap<Taxon, double[]> result = new HashMap<Taxon, double[]>();
        final Dataset fullData = Dataset.DatasetType.HGDP.loadDataset();
        loader.setData(fullData);
        CTMC ctmc = loader.load();
        CTMCUtils.saveInExec(ctmc, "init");
        final Map<Taxon, String> pops = fullData.getReferenceClusters();
        HashSet<String> allPopulations = new HashSet<String>(pops.values());
        Map<Taxon, double[][]> allData = fullData.observations();
        int i = 1;
        for (String currentPopulation : allPopulations) {
            LogInfo.track((Object)("Processing population " + currentPopulation + " (" + i++ + "/" + allPopulations.size() + ")"), true);
            final Map<Taxon, double[][]> _restrictedData = this.dataForPopulation(pops, allData, currentPopulation);
            Dataset restrictedData = new Dataset(){

                @Override
                public Map<Taxon, String> getReferenceClusters() {
                    return pops;
                }

                @Override
                public boolean hasReferenceClusters() {
                    return true;
                }

                @Override
                public Map<Taxon, double[][]> observations() {
                    return _restrictedData;
                }

                @Override
                public int nCharacter(int site) {
                    return fullData.nCharacter(site);
                }

                @Override
                public int nSites() {
                    return fullData.nSites();
                }
            };
            PartialCoalescentState initState = PartialCoalescentState.initState(restrictedData, ctmc);
            ParticleFilter.ParticleMapperProcessor<PartialCoalescentState, Set<Set<Taxon>>> mbr = SymmetricDiff.createCladeProcessor();
            ParticleFilter.MAPDecoder mapDecoder = new ParticleFilter.MAPDecoder();
            ParticleFilter.ForkedProcessor processors = new ParticleFilter.ForkedProcessor(mbr, mapDecoder);
            PriorPriorKernel kernel = new PriorPriorKernel(initState);
            pf.sample(kernel, processors);
            result.put(new Taxon(currentPopulation), this.getRootPosterior((PartialCoalescentState)mapDecoder.map()));
            Train.outputTree(SymmetricDiff.clades2arbre(mbr.centroid(SymmetricDiff.CLADE_SYMMETRIC_DIFFERENCE)), "consensusTree-" + currentPopulation);
            LogInfo.end_track();
        }
        this.writeResult(result);
    }

    private void writeResult(Map<Taxon, double[]> result) {
        String file = Execution.getFile("result");
        PrintWriter out = IOUtils.openOutHard(file);
        for (Taxon lang : result.keySet()) {
            out.append(lang + "\t");
            out.append(StrUtils.join(result.get(lang), "\t") + "\n");
        }
        out.close();
    }

    private double[] getRootPosterior(PartialCoalescentState state) {
        int nSites = state.getCTMC().nSites();
        Arbre<Taxon> a = state.getArbreAndBranchLengths().getFirst();
        Taxon root = a.getContents();
        double[] result = new double[nSites];
        for (int s = 0; s < nSites; ++s) {
            GMFct<Taxon> posterior = DiscreteBP.posteriorMarginalTransitions(state, s);
            result[s] = posterior.get(root, 0);
        }
        return result;
    }

    private Map<Taxon, double[][]> dataForPopulation(Map<Taxon, String> pops, Map<Taxon, double[][]> allData, String currentPopulation) {
        HashMap<Taxon, double[][]> result = new HashMap<Taxon, double[][]>();
        for (Taxon lang : allData.keySet()) {
            if (!pops.get(lang).equals(currentPopulation)) continue;
            result.put(lang, allData.get(lang));
        }
        return result;
    }

    public static void main(String[] args) {
        Execution.monitor = true;
        Execution.makeThunk = false;
        Execution.create = true;
        Execution.useStandardExecPoolDirStrategy = true;
        if (!Arrays.asList(args).contains("NOJARS")) {
            Execution.jarFiles = new ArrayList<String>(Arrays.asList("/home/eecs/bouchard/jars/ptychodus.jar", "/home/eecs/bouchard/jars/nuts.jar", "/home/eecs/bouchard/jars/pepper.jar", "/home/eecs/bouchard/jars/fig.jar"));
        }
        pf = new ParticleFilter();
        loader = new CTMCLoader();
        Execution.run(args, new ProcessPops(), "hgdb", HGDPDataset.class, "filter", pf, "init", loader);
    }
}

