/*
 * Decompiled with CFR 0.152.
 */
package pty.smc;

import ev.poi.processors.TreeDistancesProcessor;
import goblin.Taxon;
import java.util.List;
import java.util.Random;
import nuts.math.Sampling;
import pty.UnrootedTree;
import pty.smc.CondSMCDissector;
import pty.smc.NCPriorPriorKernel;
import pty.smc.PartialCoalescentState;
import pty.smc.ParticleFilter;

public class PG {
    private final ParticleFilter<PartialCoalescentState> pf;
    private final NCPriorPriorKernel kernel;
    private final TreeDistancesProcessor tdp;
    private final PartialCoalescentState model;
    private UnrootedTree current = null;

    public PG(ParticleFilter<PartialCoalescentState> pf, NCPriorPriorKernel kernel, TreeDistancesProcessor tdp, PartialCoalescentState model) {
        this.pf = pf;
        this.kernel = kernel;
        this.tdp = tdp;
        this.model = model;
    }

    public void next(Random rand) {
        PartialCoalescentState.alwaysComputeTopMessage = true;
        ParticleFilter.StoreProcessor pro = new ParticleFilter.StoreProcessor();
        if (this.current == null) {
            this.pf.sample(this.kernel, pro);
            PartialCoalescentState sampled = (PartialCoalescentState)pro.sample(rand);
            this.current = UnrootedTree.fromRooted(sampled.getFullCoalescentState());
        } else {
            boolean success = false;
            CondSMCDissector dissector = null;
            for (int i = 0; i < 100; ++i) {
                Taxon t2;
                List<Integer> pair;
                List<Taxon> list = this.current.leaves();
                Taxon t1 = list.get((pair = Sampling.sampleWithoutReplacement(rand, list.size(), 2)).get(0));
                dissector = new CondSMCDissector(this.current, t1, t2 = list.get(pair.get(1)));
                if (!dissector.sampleAnchor(rand)) continue;
                success = true;
                break;
            }
            if (!success) {
                throw new RuntimeException();
            }
            List<PartialCoalescentState> path = dissector.currentSampledPath(this.model, rand);
            PartialCoalescentState init = path.get(0);
            path = path.subList(1, path.size());
            this.kernel.setInitial(init);
            double[] weights = new double[path.size()];
            for (int i = 0; i < weights.length; ++i) {
                weights[i] = NCPriorPriorKernel.useOptimal ? path.get(i).nonClockLogWeight() : path.get(i).logLikelihoodRatio() - Math.log(path.get(i).nNonTrivialRoots());
            }
            this.pf.setConditional(path, weights);
            this.pf.sample(this.kernel, pro);
            PartialCoalescentState sampled = (PartialCoalescentState)pro.sample(rand);
            this.current = dissector.reconstitute(sampled);
        }
        this.tdp.process(this.current);
    }
}

