/*
 * Decompiled with CFR 0.152.
 */
package pty.smc;

import fig.basic.Pair;
import fig.prob.Multinomial;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import nuts.maxent.SloppyMath;
import nuts.util.Arbre;
import nuts.util.Counter;
import pty.smc.PartialCoalescentState;
import pty.smc.ParticleKernel;
import pty.smc.models.BrownianModelCalculator;

public class PostPostKernel
implements ParticleKernel<PartialCoalescentState> {
    private PartialCoalescentState initial;

    public PostPostKernel(PartialCoalescentState initial) {
        this.initial = initial;
        if (!initial.isClock()) {
            throw new RuntimeException("Not yet supported");
        }
    }

    @Override
    public Pair<PartialCoalescentState, Double> next(Random rand, PartialCoalescentState state) {
        ArrayList tmp;
        double lognorm;
        int nroots = state.nRoots();
        ArrayList candidateStates = new ArrayList();
        ArrayList candidateProbabilities = new ArrayList();
        for (int i = 0; i < 2 * (nroots - 1) - 1; ++i) {
            candidateStates.add(new ArrayList());
            candidateProbabilities.add(new ArrayList());
        }
        Counter<String> mergers = new Counter<String>();
        double[] tmparray = new double[nroots * (nroots - 1) / 2];
        int count = 0;
        for (int i = 0; i < nroots; ++i) {
            for (int j = 0; j < i; ++j) {
                PartialCoalescentState oldState = state;
                List<Arbre<PartialCoalescentState.CoalescentNode>> roots = oldState.getRoots();
                PartialCoalescentState.CoalescentNode node1 = roots.get(i).getContents();
                PartialCoalescentState.CoalescentNode node2 = roots.get(j).getContents();
                BrownianModelCalculator bmc = (BrownianModelCalculator)node1.likelihoodModelCache;
                double weight = bmc.evaluatePair(node1, node2, oldState.nRoots(), oldState.topHeight());
                ArrayList tmp2 = (ArrayList)candidateProbabilities.get(i + j - 1);
                tmp2.add(weight);
                tmparray[count++] = weight;
                mergers.setCount("Weight for " + node1.nodeIdentifier + "," + node2.nodeIdentifier + "=", weight);
            }
        }
        double particleweight = lognorm = SloppyMath.logAdd(tmparray);
        double[] firstLevelProbs = new double[candidateProbabilities.size()];
        for (int i = 0; i < candidateProbabilities.size(); ++i) {
            tmp = (ArrayList)candidateProbabilities.get(i);
            firstLevelProbs[i] = Math.exp(this.logAdd(tmp) - lognorm);
        }
        int firstLevel = Multinomial.sample(rand, firstLevelProbs);
        tmp = (ArrayList)candidateProbabilities.get(firstLevel);
        double[] secondLevelProbs = new double[tmp.size()];
        for (int i = 0; i < secondLevelProbs.length; ++i) {
            secondLevelProbs[i] = Math.exp((Double)tmp.get(i) - lognorm) / firstLevelProbs[firstLevel];
        }
        int secondLevel = Multinomial.sample(rand, secondLevelProbs);
        double weight = (Double)tmp.get(secondLevel);
        Pair<Integer, Integer> p = this.level2index(firstLevel, secondLevel);
        int i = p.getFirst();
        int j = p.getSecond();
        List<Arbre<PartialCoalescentState.CoalescentNode>> roots = state.getRoots();
        PartialCoalescentState.CoalescentNode node1 = roots.get(i).getContents();
        PartialCoalescentState.CoalescentNode node2 = roots.get(j).getContents();
        BrownianModelCalculator bmc = (BrownianModelCalculator)node1.likelihoodModelCache;
        Pair<Double, Double> result = bmc.sampleBranchLength(node1, node2, state.topHeight(), state.nRoots(), weight, rand);
        double delta = result.getFirst();
        double correct = result.getSecond();
        PartialCoalescentState newState = state.coalesce(i, j, delta, 0.0, 0.0);
        return Pair.makePair(newState, particleweight += correct);
    }

    @Override
    public int nIterationsLeft(PartialCoalescentState state) {
        return state.nIterationsLeft();
    }

    @Override
    public PartialCoalescentState getInitial() {
        return this.initial;
    }

    private double logAdd(ArrayList<Double> tmp) {
        double[] tmparray = new double[tmp.size()];
        for (int i = 0; i < tmp.size(); ++i) {
            tmparray[i] = tmp.get(i);
        }
        return SloppyMath.logAdd(tmparray);
    }

    public Pair<Integer, Integer> level2index(int firstLevel, int secondLevel) {
        int i;
        int j;
        if (++firstLevel % 2 == 1) {
            j = firstLevel / 2;
            i = firstLevel - j;
        } else {
            j = firstLevel / 2 - 1;
            i = firstLevel / 2 + 1;
        }
        return new Pair<Integer, Integer>(i += secondLevel, j -= secondLevel);
    }
}

