/*
 * Decompiled with CFR 0.152.
 */
package pty.smc;

import fig.basic.Pair;
import fig.prob.Multinomial;
import java.util.ArrayList;
import java.util.Random;
import nuts.math.Sampling;
import nuts.maxent.SloppyMath;
import pty.smc.PartialCoalescentState;
import pty.smc.ParticleKernel;
import pty.smc.PriorPriorKernel;

public class PriorPostKernel
implements ParticleKernel<PartialCoalescentState> {
    private PartialCoalescentState initial;

    public PriorPostKernel(PartialCoalescentState initial) {
        this.initial = initial;
        if (!initial.isClock()) {
            throw new RuntimeException("Not yet supported");
        }
    }

    @Override
    public Pair<PartialCoalescentState, Double> next(Random rand, PartialCoalescentState state) {
        ArrayList tmp;
        double delta = Sampling.sampleExponential(rand, 1.0 / PriorPriorKernel.nChoose2(state.nRoots()));
        int nroots = state.nRoots();
        ArrayList candidateStates = new ArrayList();
        ArrayList candidateProbabilities = new ArrayList();
        for (int i = 0; i < 2 * (nroots - 1) - 1; ++i) {
            candidateStates.add(new ArrayList());
            candidateProbabilities.add(new ArrayList());
        }
        double[] tmparray = new double[nroots * (nroots - 1) / 2];
        int count = 0;
        for (int i = 0; i < nroots; ++i) {
            for (int j = 0; j < i; ++j) {
                PartialCoalescentState oldState = state;
                PartialCoalescentState newState = oldState.coalesce(i, j, delta, 0.0, 0.0);
                ArrayList tmpState = (ArrayList)candidateStates.get(i + j - 1);
                tmpState.add(newState);
                ArrayList tmp2 = (ArrayList)candidateProbabilities.get(i + j - 1);
                tmp2.add(newState.logLikelihoodRatio());
                tmparray[count++] = newState.logLikelihoodRatio();
            }
        }
        double lognorm = SloppyMath.logAdd(tmparray);
        double[] firstLevelProbs = new double[candidateProbabilities.size()];
        for (int i = 0; i < candidateProbabilities.size(); ++i) {
            tmp = (ArrayList)candidateProbabilities.get(i);
            firstLevelProbs[i] = Math.exp(this.logAdd(tmp) - lognorm);
        }
        int firstLevel = Multinomial.sample(rand, firstLevelProbs);
        tmp = (ArrayList)candidateProbabilities.get(firstLevel);
        double[] secondLevelProbs = new double[tmp.size()];
        for (int i = 0; i < secondLevelProbs.length; ++i) {
            secondLevelProbs[i] = Math.exp((Double)tmp.get(i) - lognorm) / firstLevelProbs[firstLevel];
        }
        int secondLevel = Multinomial.sample(rand, secondLevelProbs);
        ArrayList tmpState = (ArrayList)candidateStates.get(firstLevel);
        PartialCoalescentState result = (PartialCoalescentState)tmpState.get(secondLevel);
        return Pair.makePair(result, lognorm);
    }

    @Override
    public int nIterationsLeft(PartialCoalescentState state) {
        return state.nIterationsLeft();
    }

    @Override
    public PartialCoalescentState getInitial() {
        return this.initial;
    }

    private double logAdd(ArrayList<Double> tmp) {
        double[] tmparray = new double[tmp.size()];
        for (int i = 0; i < tmp.size(); ++i) {
            tmparray[i] = tmp.get(i);
        }
        return SloppyMath.logAdd(tmparray);
    }
}

