/*
 * Decompiled with CFR 0.152.
 */
package sage;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import nuts.io.IO;
import nuts.lang.StringUtils;

public class ConvertScience {
    public static final String NUMBERING_LINE = "^\\s+([0-9]+)$";
    public static final String CONTENTS_LINE = "^([0-9A-Za-z_.]+)\\s+((?:[-A-Z.]+\\s+)+[-A-Z.]+)$";
    private StringBuilder currentBlock = this.prefix();
    private final List<String> lines = new ArrayList<String>();
    private int counter = 0;
    private File outputDirectory;
    private final String outputPrefix;
    private int nBases = 0;
    StringBuilder corpusFormat = new StringBuilder();
    private int currentPosition = -1;
    private List<String> langs = new ArrayList<String>();
    private List<List<String>> seqns = new ArrayList<List<String>>();
    private List<String> cSeq = new ArrayList<String>();
    public static int nBasesThreshold = 50;

    public void simpleConversion(File outputDirectory) throws IOException {
        this.outputDirectory = outputDirectory;
        for (String line : this.lines) {
            if (line.matches(NUMBERING_LINE)) {
                int newPosition;
                this.currentPosition = newPosition = Integer.parseInt(StringUtils.selectFirstRegex(NUMBERING_LINE, line));
                if (newPosition <= 1) continue;
                this.dump();
                continue;
            }
            if (!line.matches(CONTENTS_LINE)) continue;
            this.nBases += ConvertScience.nBases(line);
            String converted = this.toMSF(line);
            this.currentBlock.append(converted + '\n');
            if (this.currentPosition == 1) {
                this.langs.add(StringUtils.selectFirstRegex(CONTENTS_LINE, converted));
            }
            this.cSeq.add(StringUtils.multiSelectFirstRegex(CONTENTS_LINE, converted).get(1).replaceAll("[^ACGT]", ""));
        }
        this.dump();
        this.writeCorpusFile();
    }

    private void writeCorpusFile() throws IOException {
        File outputFile = new File(this.outputDirectory, "corpus");
        StringBuilder output = new StringBuilder();
        output.append("#id ");
        for (String lang : this.langs) {
            output.append(lang + " ");
        }
        output.append("\n");
        int i = 0;
        for (List<String> cSeqns : this.seqns) {
            output.append("block" + i + " ");
            for (String s : cSeqns) {
                output.append(this.hack(s) + " ");
            }
            ++i;
            output.append("\n");
        }
        System.out.println(output);
        IO.writeToDisk(outputFile, output.toString());
    }

    private String hack(String s) {
        if (s.length() == 0) {
            s = "?";
        }
        return s;
    }

    private static int nBases(String seqn) {
        int result = 0;
        for (char c : seqn.toCharArray()) {
            if (!("" + c).matches("[ACGT]")) continue;
            ++result;
        }
        return result;
    }

    private void dump() throws IOException {
        this.currentBlock.append('\n');
        File outFile = new File(this.outputDirectory, this.outputPrefix + this.counter + ".msf");
        IO.writeToDisk(outFile, this.currentBlock.toString());
        if (this.langs.size() != this.cSeq.size()) {
            throw new RuntimeException();
        }
        this.seqns.add(this.cSeq);
        this.cSeq = new ArrayList<String>();
        ++this.counter;
        this.currentBlock = this.prefix();
        this.nBases = 0;
    }

    private String toMSF(String line) {
        return line.replaceAll("[.]", "").replaceAll("[-]", ".");
    }

    private StringBuilder prefix() {
        StringBuilder result = new StringBuilder();
        result.append("PileUp\n\n//\n\n");
        return result;
    }

    public ConvertScience(File path) {
        this.outputPrefix = path.getName();
        for (String line : IO.i(path)) {
            this.lines.add(line);
        }
    }

    public static void main(String[] args) throws IOException {
        ConvertScience cs = new ConvertScience(new File(args[0]));
        cs.simpleConversion(new File(args[1]));
    }
}

