/*
 * Decompiled with CFR 0.152.
 */
package sage;

import fig.basic.Option;
import goblin.HLFeatureExtractor;
import goblin.HLParams;
import goblin.Taxon;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import nuts.maxent.FeatureExtractor;
import nuts.maxent.LabeledInstance;
import nuts.util.Counter;
import pepper.Encodings;
import pepper.PhonemeEqClass;
import sage.FatContext;

public final class FatFeatureExtractor
implements FeatureExtractor<LabeledInstance<FatContext, HLParams.HLOutcome>, Object> {
    private static final long serialVersionUID = 1L;
    @Option
    public static ArrayList<FatFeatureTemplate> fatTemplates = new ArrayList();
    private final HLFeatureExtractor baseExtractor;
    private static Set<FatContext.Granularity> _gran = null;
    private static boolean forceContext = false;

    public FatFeatureExtractor(HLFeatureExtractor baseExtractor) {
        this.baseExtractor = baseExtractor;
    }

    public static String trigram(LabeledInstance<HLParams.HLContext, HLParams.HLOutcome> instance, char prevPrev, boolean collapsed) {
        Encodings enc = instance.getInput().enc;
        char prevChar = HLFeatureExtractor.map(enc, instance.getInput().prevChar(), collapsed);
        char curChar = HLFeatureExtractor.map(enc, instance.getLabel().outcomeChar(), collapsed);
        prevPrev = HLFeatureExtractor.map(enc, prevPrev, collapsed);
        return "[" + prevPrev + " " + prevChar + " " + curChar + "]";
    }

    public static void triLmFeatures(LabeledInstance<FatContext, HLParams.HLOutcome> instance, Counter<Object> features, boolean global, boolean collapsed) {
        if (instance.getLabel().isSpecial()) {
            throw new RuntimeException();
        }
        LabeledInstance<HLParams.HLContext, HLParams.HLOutcome> base = FatContext.project(instance);
        String namePrefix = "I[" + (global ? "" : "LANGUAGE=" + base.getInput().botLang + ",");
        features.incrementCount(namePrefix + "TRI=" + FatFeatureExtractor.trigram(base, instance.getInput().prevPrev().charValue(), collapsed) + "]", 1.0);
        if (base.getInput().isRoot()) {
            namePrefix = namePrefix + "IS-ROOT,";
            features.incrementCount(namePrefix + "TRI=" + FatFeatureExtractor.trigram(base, instance.getInput().prevPrev().charValue(), collapsed) + "]", 1.0);
        }
    }

    public static void extractLongGapFeatures(LabeledInstance<FatContext, HLParams.HLOutcome> instance, Counter<Object> features, FatFeatureExtractor ext, String langStr, int gapThr) {
        String gapThrStr;
        LabeledInstance<HLParams.HLContext, HLParams.HLOutcome> base = FatContext.project(instance);
        if (HLFeatureExtractor.isRootModel(base)) {
            return;
        }
        String string = gapThrStr = gapThr == 0 ? "" : "" + gapThr;
        if (instance.getInput().insGapLength() > gapThr) {
            if (HLFeatureExtractor.isPhonemeInsertion(base)) {
                features.incrementCount("LONGINSERT" + gapThrStr + langStr, 1.0);
            } else if (HLFeatureExtractor.isStopInsertion(base)) {
                features.incrementCount("LONGINSERTIONSTOP" + gapThrStr + langStr, 1.0);
            }
        } else if (instance.getInput().delGapLength() > gapThr) {
            if (HLFeatureExtractor.isDeletion(base)) {
                features.incrementCount("LONGDEL" + gapThrStr + langStr, 1.0);
            } else if (HLFeatureExtractor.isSubstitution(base)) {
                features.incrementCount("LONGSUB" + gapThrStr + langStr, 1.0);
            }
        }
    }

    public static void forceContext() {
        forceContext = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<FatContext.Granularity> granularities() {
        if (_gran != null) {
            return _gran;
        }
        Class<FatFeatureExtractor> clazz = FatFeatureExtractor.class;
        synchronized (FatFeatureExtractor.class) {
            if (_gran != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return _gran;
            }
            _gran = new HashSet<FatContext.Granularity>();
            if (forceContext) {
                _gran.add(FatContext.Granularity.PREVPREV);
            }
            for (FatFeatureTemplate fatTemplate : fatTemplates) {
                _gran.addAll(fatTemplate.granularities());
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return _gran;
        }
    }

    @Override
    public Counter<Object> extractFeatures(LabeledInstance<FatContext, HLParams.HLOutcome> instance) {
        Counter<Object> result = new Counter<Object>();
        this.baseExtractor.extractFeatures(FatContext.project(instance), result);
        for (FatFeatureTemplate template : fatTemplates) {
            template.extractFeatures(instance, result, this);
        }
        return result;
    }

    @Override
    public double regularizationFactor(Object feature) {
        return 1.0;
    }

    public static enum FatFeatureTemplate {
        LANGUAGE_LG(true, new FatContext.Granularity[]{FatContext.Granularity.GAP_LENGTHS}){

            @Override
            void extractFeatures(LabeledInstance<FatContext, HLParams.HLOutcome> instance, Counter<Object> features, FatFeatureExtractor ext) {
                FatFeatureExtractor.extractLongGapFeatures(instance, features, ext, ",lang=" + instance.getInput().getBaseContext().botLang, 0);
            }
        }
        ,
        SEGMENT_LOSS(false, new FatContext.Granularity[]{FatContext.Granularity.GAP_LENGTHS, FatContext.Granularity.NEXT_TOP, FatContext.Granularity.PREV_TOP}){

            @Override
            void extractFeatures(LabeledInstance<FatContext, HLParams.HLOutcome> instance, Counter<Object> features, FatFeatureExtractor ext) {
                LabeledInstance<HLParams.HLContext, HLParams.HLOutcome> base = FatContext.project(instance);
                if (!HLFeatureExtractor.isDeletion(base)) {
                    return;
                }
                Encodings enc = base.getInput().enc;
                boolean curIsVowel = enc.retrieveEqClass(enc.phoneId2EqClassId(base.getInput().top)).isVowel();
                if (!curIsVowel) {
                    return;
                }
                char topPrev = instance.getInput().prevTop().charValue();
                char topNext = instance.getInput().nextTop().charValue();
                if (topNext != enc.boundChar() && enc.retrieveEqClass(enc.char2EqClassId(topNext)).isVowel()) {
                    return;
                }
                if (topPrev == enc.boundChar()) {
                    return;
                }
                if (enc.retrieveEqClass(enc.char2EqClassId(topPrev)).isVowel()) {
                    return;
                }
                if (instance.getInput().delGapLength() == 0) {
                    return;
                }
                features.incrementCount("1[CV -> null / {C,#}]", 1.0);
            }
        }
        ,
        NONPARAM_LG(false, new FatContext.Granularity[]{FatContext.Granularity.GAP_LENGTHS}){

            @Override
            void extractFeatures(LabeledInstance<FatContext, HLParams.HLOutcome> instance, Counter<Object> features, FatFeatureExtractor ext) {
                for (int i = 0; i < 4; ++i) {
                    FatFeatureExtractor.extractLongGapFeatures(instance, features, ext, "", i);
                }
            }
        }
        ,
        BASIC_LG(false, new FatContext.Granularity[]{FatContext.Granularity.GAP_LENGTHS}){

            @Override
            void extractFeatures(LabeledInstance<FatContext, HLParams.HLOutcome> instance, Counter<Object> features, FatFeatureExtractor ext) {
                FatFeatureExtractor.extractLongGapFeatures(instance, features, ext, "", 0);
            }
        }
        ,
        NEXT_TOP(false, new FatContext.Granularity[]{FatContext.Granularity.NEXT_TOP}){

            @Override
            void extractFeatures(LabeledInstance<FatContext, HLParams.HLOutcome> instance, Counter<Object> features, FatFeatureExtractor ext) {
                LabeledInstance<HLParams.HLContext, HLParams.HLOutcome> base = FatContext.project(instance);
                if (HLFeatureExtractor.isRootModel(base)) {
                    return;
                }
                Character topLeft = instance.getInput().nextTop();
                if (HLFeatureExtractor.isStopInsertion(base)) {
                    features.incrementCount("INSERTIONSTOP,topleft=" + topLeft, 1.0);
                } else if (HLFeatureExtractor.isPhonemeInsertion(base)) {
                    features.incrementCount("INSERT,topleft=" + topLeft, 1.0);
                } else if (HLFeatureExtractor.isDeletion(base)) {
                    features.incrementCount("DELETION,topleft=" + topLeft, 1.0);
                }
            }
        }
        ,
        LOC_TRIGRAM(true, new FatContext.Granularity[]{FatContext.Granularity.PREVPREV}){

            @Override
            void extractFeatures(LabeledInstance<FatContext, HLParams.HLOutcome> instance, Counter<Object> features, FatFeatureExtractor ext) {
                if (instance.getLabel().isSpecial()) {
                    return;
                }
                FatFeatureExtractor.triLmFeatures(instance, features, false, false);
            }
        }
        ,
        GLO_TRIGRAM(false, new FatContext.Granularity[]{FatContext.Granularity.PREVPREV}){

            @Override
            void extractFeatures(LabeledInstance<FatContext, HLParams.HLOutcome> instance, Counter<Object> features, FatFeatureExtractor ext) {
                if (instance.getLabel().isSpecial()) {
                    return;
                }
                FatFeatureExtractor.triLmFeatures(instance, features, true, false);
            }
        }
        ,
        LOC_COL_TRIGRAM(true, new FatContext.Granularity[]{FatContext.Granularity.PREVPREV}){

            @Override
            void extractFeatures(LabeledInstance<FatContext, HLParams.HLOutcome> instance, Counter<Object> features, FatFeatureExtractor ext) {
                if (instance.getLabel().isSpecial()) {
                    return;
                }
                FatFeatureExtractor.triLmFeatures(instance, features, false, true);
            }
        }
        ,
        GLO_COL_TRIGRAM(false, new FatContext.Granularity[]{FatContext.Granularity.PREVPREV}){

            @Override
            void extractFeatures(LabeledInstance<FatContext, HLParams.HLOutcome> instance, Counter<Object> features, FatFeatureExtractor ext) {
                if (instance.getLabel().isSpecial()) {
                    return;
                }
                FatFeatureExtractor.triLmFeatures(instance, features, true, true);
            }
        }
        ,
        GREEK(true, new FatContext.Granularity[]{FatContext.Granularity.NEXT_TOP, FatContext.Granularity.PREV_TOP}){
            public final Set<String> r1RHS = new HashSet<String>(Arrays.asList("nonlabialized"));
            public final Set<String> r2RHS = new HashSet<String>(Arrays.asList("alveolar", "nonlabialized"));
            public final Set<String> r3RHS = new HashSet<String>(Arrays.asList("bilabial", "nonlabialized"));

            @Override
            void extractFeatures(LabeledInstance<FatContext, HLParams.HLOutcome> instance, Counter<Object> features, FatFeatureExtractor ext) {
                LabeledInstance<HLParams.HLContext, HLParams.HLOutcome> base = FatContext.project(instance);
                Encodings enc = base.getInput().enc;
                Taxon lang = base.getInput().botLang;
                if (!HLFeatureExtractor.isSubstitution(base) || HLFeatureExtractor.isSelfSubstitution(base)) {
                    return;
                }
                PhonemeEqClass eq1 = enc.phoneId2EqClassObject(base.getInput().top);
                PhonemeEqClass eq2 = enc.phoneId2EqClassObject(instance.getLabel().outcome);
                if (eq1.isVowel() || eq2.isVowel()) {
                    return;
                }
                if (!eq1.getFeature(PhonemeEqClass.PhonemeFeatureTypes.LABIALIZATION).equals("labialized")) {
                    return;
                }
                if (!eq1.getFeature(PhonemeEqClass.PhonemeFeatureTypes.PLACE).equals("velar")) {
                    return;
                }
                List<String> newFeatures = HLFeatureExtractor.modifiedFeatures(base);
                char topPrev = instance.getInput().prevTop().charValue();
                char topNext = instance.getInput().nextTop().charValue();
                if (this.r1RHS.equals(newFeatures)) {
                    if (topNext != 'u' && topPrev != 'u') {
                        return;
                    }
                    features.incrementCount("R1@" + lang, 1.0);
                } else if (this.r2RHS.equals(newFeatures)) {
                    PhonemeEqClass topNextEqClass = enc.phoneId2EqClassObject(enc.char2PhoneId(topNext));
                    if (topNext == enc.boundChar() || !topNextEqClass.isVowel() || !topNextEqClass.getFeature(PhonemeEqClass.PhonemeFeatureTypes.BACKNESS).equals("front")) {
                        return;
                    }
                    features.incrementCount("R2@" + lang, 1.0);
                } else if (this.r3RHS.equals(newFeatures)) {
                    features.incrementCount("R3@" + lang, 1.0);
                }
            }
        }
        ,
        GREEK2(true, new FatContext.Granularity[]{FatContext.Granularity.NEXT_TOP, FatContext.Granularity.PREV_TOP}){

            @Override
            void extractFeatures(LabeledInstance<FatContext, HLParams.HLOutcome> instance, Counter<Object> features, FatFeatureExtractor ext) {
                LabeledInstance<HLParams.HLContext, HLParams.HLOutcome> base = FatContext.project(instance);
                Encodings enc = base.getInput().enc;
                Taxon lang = base.getInput().botLang;
                if (!HLFeatureExtractor.isSubstitution(base) || HLFeatureExtractor.isSelfSubstitution(base)) {
                    return;
                }
                PhonemeEqClass eq1 = enc.phoneId2EqClassObject(base.getInput().top);
                PhonemeEqClass eq2 = enc.phoneId2EqClassObject(instance.getLabel().outcome);
                if (eq1.isVowel() || eq2.isVowel()) {
                    return;
                }
                if (!eq1.getFeature(PhonemeEqClass.PhonemeFeatureTypes.LABIALIZATION).equals("labialized")) {
                    return;
                }
                List<String> newFeatures = HLFeatureExtractor.modifiedFeatures(base);
                if (newFeatures.size() == 0 || newFeatures.size() > 2) {
                    return;
                }
                char topPrev = instance.getInput().prevTop().charValue();
                char topNext = instance.getInput().nextTop().charValue();
                String rule = "[labiovelar] > " + newFeatures.toString();
                features.incrementCount(rule + " @ " + lang, 1.0);
                if (topNext == 'u' || topPrev == 'u') {
                    features.incrementCount(rule + " // u @ " + lang, 1.0);
                }
                PhonemeEqClass topNextEqClass = enc.phoneId2EqClassObject(enc.char2PhoneId(topNext));
                if (topNext != enc.boundChar() && topNextEqClass.isVowel()) {
                    features.incrementCount(rule + " / _ " + topNextEqClass.getFeature(PhonemeEqClass.PhonemeFeatureTypes.BACKNESS) + " @ " + lang, 1.0);
                }
            }
        }
        ,
        GREEK3(true, new FatContext.Granularity[]{FatContext.Granularity.PREV_TOP, FatContext.Granularity.NEXT_TOP, FatContext.Granularity.PREVPREV}){

            @Override
            void extractFeatures(LabeledInstance<FatContext, HLParams.HLOutcome> instance, Counter<Object> features, FatFeatureExtractor ext) {
                LabeledInstance<HLParams.HLContext, HLParams.HLOutcome> base = FatContext.project(instance);
                Encodings enc = base.getInput().enc;
                Taxon lang = base.getInput().botLang;
                if (HLFeatureExtractor.isRootModel(base)) {
                    return;
                }
                char prevTop = instance.getInput().prevTop().charValue();
                char nextTop = instance.getInput().nextTop().charValue();
                char prev = base.getInput().prevChar();
                char top = base.getInput().topChar();
                char prevPrev = instance.getInput().prevPrev().charValue();
                if (lang.toString().equals("intern0")) {
                    PhonemeEqClass eq1 = enc.phoneId2EqClassObject(enc.char2PhoneId(prevTop));
                    PhonemeEqClass eq2 = enc.phoneId2EqClassObject(enc.char2PhoneId(nextTop));
                    if (HLFeatureExtractor.isDeletion(base) && top == 's' && prevTop != enc.boundChar() && nextTop != enc.boundChar() && eq1.isVowel() && eq2.isVowel()) {
                        features.incrementCount("s -> <S> / V _ V @ " + lang, 1.0);
                    }
                }
                if (!lang.toString().equals("Attic")) {
                    return;
                }
                if (HLFeatureExtractor.isSubstitution(base) && prevTop == 'k' && top == 'j' && prev == 't' && base.getLabel().outcomeChar() == 't' && prevPrev != enc.boundChar()) {
                    features.incrementCount("kj > tt @" + lang, 1.0);
                } else if (HLFeatureExtractor.isSubstitution(base) && prevTop == 'k' && top == 'j' && prev == enc.boundChar() && base.getLabel().outcomeChar() == 't') {
                    features.incrementCount("kj > #t @" + lang, 1.0);
                } else if (HLFeatureExtractor.isDeletion(base) && top == 't' && nextTop == 's') {
                    features.incrementCount("ts > s @" + lang, 1.0);
                }
            }
        }
        ,
        GREEK_MORPHO(true, new FatContext.Granularity[]{FatContext.Granularity.COGNATE_ID, FatContext.Granularity.NEXT_TOP}){

            @Override
            void extractFeatures(LabeledInstance<FatContext, HLParams.HLOutcome> instance, Counter<Object> features, FatFeatureExtractor ext) {
                LabeledInstance<HLParams.HLContext, HLParams.HLOutcome> base = FatContext.project(instance);
                Encodings enc = base.getInput().enc;
                Taxon lang = base.getInput().botLang;
                if (!lang.toString().equals("intern1") || HLFeatureExtractor.isRootModel(base)) {
                    return;
                }
                char nextTop = instance.getInput().nextTop().charValue();
                if (nextTop != enc.boundChar()) {
                    return;
                }
                char previous = base.getInput().prevChar();
                if (base.getLabel().isSpecial()) {
                    return;
                }
                char current = base.getLabel().outcomeChar();
                String cogStr = instance.getInput().cognateId().toString();
                if (!cogStr.startsWith("(I")) {
                    return;
                }
                boolean conformsVerbParadigms = false;
                if (cogStr.startsWith("(IWill)")) {
                    if (previous == 's' && current == 'o') {
                        conformsVerbParadigms = true;
                    }
                } else if (cogStr.startsWith("(I)") && (cogStr.endsWith("ed") || cogStr.contains("was") || cogStr.contains("did") || cogStr.contains("struck") || cogStr.contains("stole"))) {
                    if (previous == 's' && current == 'a') {
                        conformsVerbParadigms = true;
                    }
                } else if (previous == 'j' && current == 'o') {
                    conformsVerbParadigms = true;
                }
                if (conformsVerbParadigms) {
                    features.incrementCount("MORPH@" + lang, 1.0);
                }
            }
        }
        ,
        HYDRO_TYPE(false, new FatContext.Granularity[]{FatContext.Granularity.HYDROPHOBIC}){

            @Override
            void extractFeatures(LabeledInstance<FatContext, HLParams.HLOutcome> instance, Counter<Object> features, FatFeatureExtractor ext) {
                LabeledInstance<HLParams.HLContext, HLParams.HLOutcome> base = FatContext.project(instance);
                if (HLFeatureExtractor.isRootModel(base)) {
                    return;
                }
                if (instance.getInput().isHydrophilic()) {
                    if (HLFeatureExtractor.isPhonemeInsertion(base)) {
                        features.incrementCount("HYDROINSERT", 1.0);
                    } else if (HLFeatureExtractor.isStopInsertion(base)) {
                        features.incrementCount("HYDROINSERTIONSTOP", 1.0);
                    }
                    if (HLFeatureExtractor.isDeletion(base)) {
                        features.incrementCount("HYDRODEL", 1.0);
                    } else if (HLFeatureExtractor.isSubstitution(base)) {
                        features.incrementCount("HYDROSUB", 1.0);
                    }
                }
            }
        };

        private Set<FatContext.Granularity> granularities = new HashSet<FatContext.Granularity>();
        public final boolean usesLanguageField;

        private FatFeatureTemplate(boolean usesLanguageField, FatContext.Granularity ... granularitiesNeeded) {
            this.usesLanguageField = usesLanguageField;
            for (FatContext.Granularity gran : granularitiesNeeded) {
                this.granularities.add(gran);
            }
        }

        abstract void extractFeatures(LabeledInstance<FatContext, HLParams.HLOutcome> var1, Counter<Object> var2, FatFeatureExtractor var3);

        public Set<FatContext.Granularity> granularities() {
            HashSet<FatContext.Granularity> result = new HashSet<FatContext.Granularity>(this.granularities);
            return result;
        }
    }
}

