/*
 * Decompiled with CFR 0.152.
 */
package sage;

import java.io.Serializable;
import java.util.ArrayList;
import nuts.io.IO;
import nuts.util.EasyFormat;
import org.apache.commons.math.MathException;
import org.apache.commons.math.stat.descriptive.DescriptiveStatistics;
import org.apache.commons.math.stat.inference.TestUtils;

public class ReadFreq {
    public static void main(String[] args) throws IllegalArgumentException, MathException {
        ArrayList<Line> lines = new ArrayList<Line>();
        Line prev = null;
        double freqBd = Double.parseDouble(args[1]);
        double changePrBd = Double.parseDouble(args[2]);
        for (String text : IO.i(args[0])) {
            if (text.charAt(0) == '#') continue;
            Line current = new Line(text);
            lines.add(current);
            if (prev != null) {
                if (current.left == prev.right && current.right == prev.left && current.leftLang.equals(prev.rightLang) && current.rightLang.equals(prev.leftLang)) {
                    current.inverse = prev;
                    prev.inverse = current;
                }
                prev = null;
                continue;
            }
            prev = current;
        }
        DescriptiveStatistics nullHyp = new DescriptiveStatistics();
        DescriptiveStatistics changed = new DescriptiveStatistics();
        DescriptiveStatistics relativeFreq = new DescriptiveStatistics();
        DescriptiveStatistics relativeFreqNull = new DescriptiveStatistics();
        System.out.println("Params: changePrBd=" + changePrBd + ",freqBd=" + freqBd);
        for (Line line : lines) {
            double relFreq = line.leftFreq / (line.leftFreq + line.rightFreq);
            if (!(line.changePr >= changePrBd) || !(line.leftFreq >= freqBd) || !((double)line.right > freqBd)) continue;
            relativeFreq.addValue(relFreq);
        }
        System.out.println("Frequency hypothesis");
        System.out.println("Sound change mean relFreq:" + relativeFreq.getMean());
        System.out.println("P-value:" + TestUtils.tTest((double)0.5, (double[])relativeFreq.getValues()));
        System.out.println("---");
        for (Object v : (Object)relativeFreq.getValues()) {
            System.out.println((double)v);
        }
    }

    public static class Line
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final char left;
        public final char right;
        public final double changePr;
        public final double changeAbs;
        public final double leftFreq;
        public final double rightFreq;
        public final String leftLang;
        public final String rightLang;
        public final String stringRep;
        public final double fLoad;
        public Line inverse = null;

        public Line(String line) {
            this.stringRep = line;
            String[] fields = line.split("\\t");
            String[] change = fields[0].split(">");
            this.left = change[0].charAt(0);
            this.right = change[1].charAt(0);
            String[] langs = fields[1].split(">");
            this.leftLang = langs[0];
            this.rightLang = langs[1];
            this.changePr = Double.parseDouble(fields[3]);
            this.changeAbs = Double.parseDouble(fields[4]);
            this.leftFreq = Double.parseDouble(fields[6]);
            this.rightFreq = Double.parseDouble(fields[7]);
            this.fLoad = Double.parseDouble(fields[2]);
        }

        public String toString() {
            return this.stringRep;
        }

        public String summary() {
            return "" + this.left + ">" + this.right + " @" + this.rightLang + " " + EasyFormat.fmt(this.changePr * 100.0) + "% (" + EasyFormat.fmt(this.changeAbs) + ")";
        }
    }
}

