/*
 * Decompiled with CFR 0.152.
 */
package sage;

import goblin.CognateId;
import goblin.CognateSet;
import goblin.HLFeatureExtractor;
import goblin.HLIntegrator;
import goblin.HLParams;
import goblin.ObservationsTracker;
import goblin.Taxon;
import java.io.IOException;
import java.util.HashSet;
import nuts.maxent.LabeledInstance;
import nuts.util.Counter;
import pepper.Encodings;
import sage.FatContext;

public class SuffStatsSummary {
    public static Counter<Integer> gapLengths(Counter<LabeledInstance<FatContext, HLParams.HLOutcome>> ss) {
        Counter<Integer> result = new Counter<Integer>();
        for (LabeledInstance<FatContext, HLParams.HLOutcome> s : ss.keySet()) {
            double mult = ss.getCount(s);
            LabeledInstance<HLParams.HLContext, HLParams.HLOutcome> prj = FatContext.project(s);
            if (!HLFeatureExtractor.isDeletion(prj) && !HLFeatureExtractor.isPhonemeInsertion(prj)) continue;
            result.incrementCount(Math.max(s.getInput().delGapLength(), s.getInput().insGapLength()), mult);
        }
        return result;
    }

    public static Counter<String> bigrams(Counter<LabeledInstance<HLParams.HLContext, HLParams.HLOutcome>> ss, ObservationsTracker restrictToObs) {
        Counter<String> result = new Counter<String>();
        for (LabeledInstance<HLParams.HLContext, HLParams.HLOutcome> s : ss.keySet()) {
            if (restrictToObs != null && !restrictToObs.isObserved(s.getInput().botLang)) continue;
            double mult = ss.getCount(s);
            if (!HLFeatureExtractor.isSubstitution(s) && !HLFeatureExtractor.isRootModel(s)) continue;
            result.incrementCount(HLFeatureExtractor.bigram(s, false), mult);
        }
        return result;
    }

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        if (args.length != 2) {
            System.err.println("[g|ob] <file>");
            System.err.println("\tg:  gapLength info");
            System.err.println("\tob: observed bigram stats");
            return;
        }
        if (args[0].equals("g")) {
            int i;
            Counter<LabeledInstance<FatContext, HLParams.HLOutcome>> ss = HLIntegrator.restoreSuffStats(args[1]);
            Counter<Integer> gl = SuffStatsSummary.gapLengths(ss);
            Counter<Integer> gl2 = new Counter<Integer>();
            for (i = 0; i < 50; ++i) {
                gl2.setCount(i + 1, gl.getCount(i) - gl.getCount(i + 1));
            }
            gl2.normalize();
            for (i = 1; i < 51; ++i) {
                System.out.println(i + "\t" + gl2.getCount(i));
            }
        } else if (args[0].equals("ob")) {
            CognateSet cs = CognateSet.restoreCognateSet(args[1]);
            HashSet<Taxon> moderns = new HashSet<Taxon>();
            Counter<LabeledInstance<HLParams.HLContext, HLParams.HLOutcome>> ss = new Counter<LabeledInstance<HLParams.HLContext, HLParams.HLOutcome>>();
            for (CognateId id : cs.getCognateIds()) {
                moderns.addAll(ObservationsTracker.modernObservationsTracker(cs.getTree(id)).observedLanguages());
                HLParams.addSuffStats(ss, cs.getTree(id), Encodings.proteinEncodings(true));
            }
            System.out.println(SuffStatsSummary.bigrams(ss, new ObservationsTracker(moderns)).toString().replaceAll(",", "\n"));
        } else {
            throw new RuntimeException("Unk:" + args[0]);
        }
    }
}

