/*
 * Decompiled with CFR 0.152.
 */
package sand;

import java.util.Arrays;
import java.util.Random;
import sand.ObservedEmissionKernel;
import sand.SandwitchSampler;
import sand.TransitionKernel;

public class GeometricKernetlTest {
    public static final int length = 5;
    public static final Random rand = new Random(1L);
    public static final double slack = 1.0E-4;

    public SandwitchSampler createSampler() {
        TransitionKernel[] transition = new TransitionKernel[5];
        ObservedEmissionKernel[] emi = new ObservedEmissionKernel[5];
        for (int t = 0; t < 5; ++t) {
            emi[t] = new ArtificialGeoObs();
            transition[t] = new ArtificialGeoTr();
        }
        return new SandwitchSampler(transition, emi, 1.0E-4, false);
    }

    public static void main(String[] args) {
        GeometricKernetlTest test = new GeometricKernetlTest();
        SandwitchSampler sampler = test.createSampler();
        int[] sample = sampler.sample(rand).getLegacyHMMHiddenStates();
        System.out.println(Arrays.toString(sample));
    }

    public static class ArtificialGeoTr
    implements TransitionKernel {
        @Override
        public int nCurrentStates() {
            return Integer.MAX_VALUE;
        }

        @Override
        public int nNextStates() {
            return Integer.MAX_VALUE;
        }

        @Override
        public double pr(int currentState, int nextState) {
            return Math.pow(2.0, -1.0 * (1.0 + (double)nextState));
        }

        @Override
        public int sample(int currentState, Random rand) {
            throw new RuntimeException();
        }
    }

    public static class ArtificialGeoObs
    implements ObservedEmissionKernel {
        @Override
        public int nStates() {
            return Integer.MAX_VALUE;
        }

        @Override
        public double pr(int state) {
            return Math.pow(2.0, -1.0 * (1.0 + (double)state));
        }
    }
}

