/*
 * Decompiled with CFR 0.152.
 */
package scratch;

import fig.prob.Beta;
import fig.prob.SampleUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import nuts.util.Counter;

public class BetaGamma {
    public static void main(String[] args) {
        double theta = 2.0;
        double k = 2.0;
        double beta = 3.0;
        double alpha = k;
        double n = 10.0;
        ArrayList<Double> values = new ArrayList<Double>();
        for (double i = 0.0; i < n; i += 1.0) {
            values.add(0.9 * (i / n) * theta);
        }
        System.out.println("Values:" + values);
        Counter<Double> sums = new Counter<Double>();
        double nIters = 100000.0;
        Random rand = new Random(1L);
        int i = 0;
        while ((double)i < nIters) {
            double cur = SampleUtils.sampleGamma(rand, alpha + beta, 1.0 / theta) * Beta.sample(rand, alpha, beta);
            Iterator iterator = values.iterator();
            while (iterator.hasNext()) {
                double t = (Double)iterator.next();
                double integrand = Math.exp(-t * cur);
                sums.incrementCount(t, integrand);
            }
            ++i;
        }
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            double t = (Double)iterator.next();
            System.out.println("Value:" + t);
            System.out.println("MC:" + sums.getCount(t) / nIters);
            System.out.println("Analytic:" + Math.pow(1.0 + theta * t, -k));
            System.out.println();
        }
    }
}

