/*
 * Decompiled with CFR 0.152.
 */
package scratch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import pepper.CognateDetector;

public class EditDistanceSearch {
    public static List<Character> alphabet = EditDistanceSearch.createAlphabet(20);
    public static final int NRef = 100;
    public static final int minL = 10;
    public static final int maxL = 15;
    public static final Random rand = new Random(1L);

    public static String randomStr(int n) {
        StringBuilder sb = new StringBuilder();
        int N = alphabet.size();
        for (int i = 0; i < n; ++i) {
            sb.append((char)(97 + rand.nextInt(N)));
        }
        return sb.toString();
    }

    public static String climb(String current, List<String> references) {
        double initial = EditDistanceSearch.dist(current, references);
        ArrayList<String> nbhs = new ArrayList<String>(EditDistanceSearch.nhbd(current));
        for (String nbh : nbhs) {
            if (!(EditDistanceSearch.dist(nbh, references) < initial)) continue;
            return nbh;
        }
        return current;
    }

    public static double dist(String s, List<String> references) {
        double sum = 0.0;
        CognateDetector cd = new CognateDetector();
        for (String r : references) {
            sum += cd.cost(r, s);
        }
        return sum;
    }

    public static List<Character> createAlphabet(int n) {
        ArrayList<Character> result = new ArrayList<Character>();
        int c = 97;
        for (int i = 0; i < n; i = (int)((char)(i + 1))) {
            result.add(Character.valueOf((char)(c + i)));
        }
        return result;
    }

    public static int randomL() {
        return rand.nextInt(5) + 10;
    }

    public static void main(String[] ars) {
        List<String> references = EditDistanceSearch.createReferences(100);
        System.out.println("Fixed initializations");
        for (String ref : references) {
            String result = EditDistanceSearch.climb(references, rand, ref);
            System.out.println("" + EditDistanceSearch.dist(result, references) + "\t" + result);
        }
        System.out.println("Random inits");
        for (int i = 0; i < 100; ++i) {
            String result = EditDistanceSearch.climb(references, rand, EditDistanceSearch.randomStr(EditDistanceSearch.randomL()));
            System.out.println("" + EditDistanceSearch.dist(result, references) + "\t" + result);
        }
    }

    private static String climb(List<String> references, Random rand, String init) {
        String previous = init;
        for (int i = 0; i < 10000; ++i) {
            String current = EditDistanceSearch.climb(previous, references);
            if (current.equals(previous)) {
                System.out.println("Found in " + i + " steps");
                return current;
            }
            previous = current;
        }
        throw new RuntimeException();
    }

    private static List<String> createReferences(int n) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            result.add(EditDistanceSearch.randomStr(EditDistanceSearch.randomL()));
        }
        return result;
    }

    public static Set<String> nhbd(String s) {
        HashSet<String> result = new HashSet<String>();
        for (int i = 0; i < s.length(); ++i) {
            result.addAll(EditDistanceSearch.substiNbhd(s, i));
            result.addAll(EditDistanceSearch.insertNbhd(s, i));
            result.add(s.substring(0, i) + s.substring(i + 1, s.length()));
        }
        result.addAll(EditDistanceSearch.insertNbhd(s, s.length()));
        return result;
    }

    private static Collection<? extends String> insertNbhd(String s, int i) {
        HashSet<String> result = new HashSet<String>();
        for (char c : alphabet) {
            result.add(s.substring(0, i) + c + s.substring(i, s.length()));
        }
        return result;
    }

    private static Collection<? extends String> substiNbhd(String s, int i) {
        HashSet<String> result = new HashSet<String>();
        for (char c : alphabet) {
            result.add(s.substring(0, i) + c + s.substring(i + 1, s.length()));
        }
        return result;
    }
}

