/*
 * Decompiled with CFR 0.152.
 */
package scratch;

import fig.basic.IOUtils;
import fig.basic.LogInfo;
import fig.basic.NumUtils;
import fig.basic.Option;
import fig.exec.Execution;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import nuts.io.IO;
import nuts.math.StatisticsMap;
import org.apache.commons.math.stat.descriptive.DescriptiveStatistics;

public class FinalGrades
implements Runnable {
    @Option
    public File f = new File("/Users/bouchard/ccourse/marking/merged.csv");
    @Option
    public double cParam = 1.0;
    private PrintWriter output;

    public static void main(String[] args) {
        IO.run(args, new FinalGrades());
    }

    private Double curve(Double parse) {
        if (parse == null) {
            this.output.print(",,");
            return null;
        }
        double newVal = Math.pow(parse, this.cParam);
        this.output.print(parse + ",");
        this.output.print(newVal + ",");
        return newVal;
    }

    public void summary(DescriptiveStatistics stats) {
        LogInfo.logs("Avg=" + stats.getMean());
        LogInfo.logs("Std dev=" + stats.getStandardDeviation());
        LogInfo.logs("p25=" + stats.getPercentile(25.0));
        LogInfo.logs("med=" + stats.getPercentile(50.0));
        LogInfo.logs("p75=" + stats.getPercentile(75.0));
        LogInfo.logs("iqr=" + (stats.getPercentile(75.0) - stats.getPercentile(25.0)));
    }

    public Double parse(String str, double total) {
        Double value = null;
        if (str == null || str.isEmpty()) {
            return 0.0;
        }
        try {
            value = Double.parseDouble(str);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (value != null) {
            return value / total;
        }
        if (str.matches("RW.*")) {
            return null;
        }
        throw new RuntimeException();
    }

    @Override
    public void run() {
        File f2 = new File(Execution.getFile("merged.csv"));
        PrintWriter toUpload = IOUtils.openOutHard(new File(Execution.getFile("to-upload.csv")));
        PrintWriter w = IOUtils.openOutHard(f2);
        this.output = IOUtils.openOutHard(new File(Execution.getFile("final-grades.csv")));
        int lineN = 0;
        for (String line : IO.i(this.f)) {
            if (lineN == 0) {
                line = "#" + line;
            }
            w.println(line);
            ++lineN;
        }
        w.close();
        StatisticsMap.DescriptiveStatisticsMap<String> itemized = new StatisticsMap.DescriptiveStatisticsMap<String>();
        DescriptiveStatistics stats = new DescriptiveStatistics();
        double sw = Double.NaN;
        double nFailed = 0.0;
        this.output.print("#id,quizes,A1,A2,A3,A4,A5,mt,final-1,final-2,total,failed\n");
        for (Map<String, String> data : IO.iCSVMap(f2)) {
            Double parsed;
            toUpload.print("2011,W,STAT,302,201,");
            String id = data.get("Student Number");
            this.output.print("" + id + ",");
            toUpload.print("" + id + ",");
            WeightedSum ws = new WeightedSum();
            WeightedSum qws = new WeightedSum();
            for (int i = 1; i <= 4; ++i) {
                String str = data.get("Quiz" + i);
                parsed = this.parse(str, i == 1 || i == 2 ? 5 : 10);
                qws.add(0.25, parsed);
            }
            this.output.print(qws.weigthedAverage() + ",");
            double[] norms = new double[]{16.0, 18.0, 23.0, 17.0, 31.0};
            for (int i = 0; i <= 4; ++i) {
                String str = data.get("A" + (i + 1));
                Double parsed2 = this.parse(str, norms[i]);
                ws.add(0.05, parsed2);
                this.output.print("" + parsed2 + ",");
            }
            String str = data.get("Midterm");
            parsed = this.parse(str, 40.0);
            ws.add(0.3, parsed);
            if (parsed != null) {
                itemized.addValue("midterm", parsed);
            }
            this.output.print("" + parsed + ",");
            boolean DNW = false;
            boolean failed = false;
            String str2 = data.get("Final Exam");
            Double parsed3 = this.curve(this.parse(str2, 90.0));
            if (parsed3 == 0.0) {
                DNW = true;
            }
            if (parsed3 != null && parsed3 < 0.5) {
                failed = true;
            }
            ws.add(0.45, parsed3);
            if (parsed3 != null) {
                itemized.addValue("final", parsed3);
            }
            if (Double.isNaN(sw)) {
                sw = ws.maxSumW();
            } else if (ws.maxSumW() != sw) {
                throw new RuntimeException();
            }
            double finalGrade = ws.weigthedAverage() + 0.05 * qws.weigthedAverage();
            if (finalGrade < 0.5 && finalGrade > 0.48) {
                finalGrade = 0.5;
            }
            if (finalGrade > 1.0) {
                finalGrade = 1.0;
            }
            if (finalGrade < 0.5) {
                failed = true;
            }
            stats.addValue(finalGrade);
            double roundedOn100 = Math.round(100.0 * finalGrade);
            toUpload.print(("" + roundedOn100).replaceAll("[.]0", "") + ",");
            this.output.print(finalGrade + ",");
            if (DNW) {
                toUpload.print("DNW");
            }
            if (failed) {
                this.output.print("*");
                nFailed += 1.0;
            }
            this.output.println();
            toUpload.println();
        }
        for (String key : itemized.keySet()) {
            LogInfo.track((Object)key, true);
            this.summary(itemized.getDescriptiveStat(key));
            LogInfo.end_track();
        }
        LogInfo.track((Object)"Overall", true);
        this.summary(stats);
        LogInfo.end_track();
        LogInfo.track((Object)"Failures", true);
        LogInfo.logs("nFailed=" + nFailed);
        LogInfo.end_track();
        this.output.close();
        toUpload.close();
    }

    public class WeightedSum {
        List<Double> weights = new ArrayList<Double>();
        List<Double> values = new ArrayList<Double>();
        double _sumW = 0.0;

        public void add(double w, Double v) {
            this._sumW += w;
            if (v == null) {
                return;
            }
            this.weights.add(w);
            this.values.add(v);
        }

        public double maxSumW() {
            return this._sumW;
        }

        public double weigthedAverage() {
            double[] array = new double[this.values.size()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = this.weights.get(i);
            }
            NumUtils.normalize(array);
            double sum = 0.0;
            for (int i = 0; i < array.length; ++i) {
                double curW = array[i];
                double v = this.values.get(i);
                if (!(curW >= 0.0) || !(v >= 0.0)) {
                    throw new RuntimeException();
                }
                sum += curW * v;
            }
            return sum;
        }

        public String toString() {
            return this.weights.toString() + " * " + this.values.toString();
        }
    }
}

