/*
 * Decompiled with CFR 0.152.
 */
package scratch;

import java.util.List;
import nuts.io.IO;
import nuts.lang.StringUtils;

public class Tupper {
    public static void main(String[] args) {
        StringBuilder out = new StringBuilder();
        for (String line : IO.i("/Users/bouchard/w/phd/contents/marf.tex")) {
            List<String> matches = StringUtils.selectRegex("\\\\cite[{]([^}]+)[}]", line);
            String init = line;
            for (String match : matches) {
                for (String subMatch : match.split(",")) {
                    try {
                        String author = StringUtils.selectFirstRegex("([^0-9]*)[0-9]+", subMatch);
                        int date = Integer.parseInt(StringUtils.selectFirstRegex("[^0-9]*([0-9]+)", subMatch));
                        if (date <= 1000) {
                            date = date > 11 ? (date += 1900) : (date += 2000);
                        }
                        String replacement = Character.toUpperCase(author.charAt(0)) + author.substring(1, author.length()) + date;
                        line = line.replaceAll(subMatch, replacement);
                    }
                    catch (Exception e) {
                        System.err.println("\n\nWARNING: Could not process:" + subMatch + "\n\n");
                    }
                }
            }
            if (!init.equals(line)) {
                System.err.println("OLD:" + init);
                System.err.println("NEW:" + line);
                System.err.println();
            }
            out.append(line + '\n');
        }
        System.out.println("---");
        IO.so(out);
    }
}

