/*
 * Decompiled with CFR 0.152.
 */
package slice.stickrep;

import java.util.ArrayList;
import java.util.List;
import slice.stickrep.Sticks;

public class LinkedSticks
implements Sticks {
    private List<Double> vs = new ArrayList<Double>();
    private double remainingStickLength = 1.0;

    @Override
    public int add(double v) {
        this.vs.add(v);
        int newIndex = this.vs.size() - 1;
        this.remainingStickLength -= this.retreiveW(newIndex);
        assert (this.remainingStickLength > 0.0);
        return newIndex;
    }

    @Override
    public double retreiveV(int index) {
        return this.vs.get(index);
    }

    @Override
    public double retreiveW(int index) {
        double result = this.vs.get(index);
        for (int i = 0; i < index; ++i) {
            result *= 1.0 - this.vs.get(i);
        }
        return result;
    }

    @Override
    public void updateV(int index, double v) {
        double oldStickRemaining = this.remainingStickLength();
        double oldLengthsAfterIndex = 1.0 - this.sumSticks(index);
        this.vs.set(index, v);
        double newLengthsAfterIndex = 1.0 - this.sumSticks(index);
        this.remainingStickLength = oldStickRemaining * newLengthsAfterIndex / oldLengthsAfterIndex;
        assert (this.remainingStickLength > 0.0);
    }

    private double sumSticks(int index) {
        double sum = 0.0;
        for (int i = 0; i <= index; ++i) {
            sum += (1.0 - sum) * this.retreiveV(i);
        }
        return sum;
    }

    @Override
    public List<Integer> largeSticks(double lowerBound) {
        ArrayList<Integer> largeSticks = new ArrayList<Integer>();
        double currentRemainingStickLength = 1.0;
        for (int i = 0; i < this.vs.size(); ++i) {
            double currentW = this.vs.get(i) * currentRemainingStickLength;
            if (currentW > lowerBound) {
                largeSticks.add(i);
            }
            currentRemainingStickLength *= 1.0 - this.vs.get(i);
        }
        return largeSticks;
    }

    @Override
    public double remainingStickLength() {
        assert (this.remainingStickLength > 0.0);
        return this.remainingStickLength;
    }

    @Override
    public int nSticks() {
        return this.vs.size();
    }

    @Override
    public int retreiveIndex(double length) {
        assert (length >= 0.0 && length <= 1.0);
        int index = -1;
        for (double current = 0.0; current <= length; current += (1.0 - current) * this.vs.get(++index)) {
        }
        assert (index >= 0);
        return index;
    }
}

