/*
 * Decompiled with CFR 0.152.
 */
package smc;

import ev.ex.GetPhylogeneticKernel;
import ev.poi.processors.TreeDistancesProcessor;
import fig.basic.LogInfo;
import fig.basic.Option;
import java.util.Random;
import nuts.io.IO;
import pty.smc.PartialCoalescentState;
import pty.smc.ParticleKernel;
import smc.EntangledParticle;
import smc.EntangledRandom;

public class PhyloRealData
implements Runnable {
    @Option(required=true)
    public int nTax;
    @Option(required=true)
    public String datafile;
    @Option(required=true)
    public int N;
    @Option(required=true)
    public int numMachines;
    @Option(required=true)
    public int machineId;
    @Option(required=true)
    public EntangledParticle.ParticleAllocationStyle allocationStyle;
    @Option(required=true)
    public Random rand1 = new Random(1L);
    @Option(required=true)
    public Random rand2 = new Random(1L);

    @Override
    public void run() {
        LogInfo.logs("machine=" + this.machineId + " starting");
        int[][] config = new int[2][this.numMachines];
        int numParticlesPerMachine = this.N / this.numMachines;
        for (int k = 0; k < this.numMachines; ++k) {
            config[0][k] = numParticlesPerMachine;
            config[1][k] = (int)Math.ceil((double)numParticlesPerMachine * 1.1);
        }
        ParticleKernel<PartialCoalescentState> kernel = GetPhylogeneticKernel.getPhyloKernel(this.nTax, this.datafile);
        EntangledRandom eRandom = new EntangledRandom(this.machineId, this.N, this.nTax - 1, this.rand1, this.rand2);
        TreeDistancesProcessor processor = new TreeDistancesProcessor();
        EntangledParticle<PartialCoalescentState> entangled = EntangledParticle.run(kernel, processor, eRandom, this.machineId, config, this.N, this.allocationStyle, null);
        entangled.printStatistics();
    }

    public static void main(String[] args) {
        IO.run(args, new PhyloRealData());
    }
}

