/*
 * Decompiled with CFR 0.152.
 */
package smc;

import fig.basic.LogInfo;

public class Timer {
    private long lastPause;
    private int ticksElapsed = 0;
    private boolean paused = false;

    public void startTimer() {
        this.lastPause = System.currentTimeMillis();
    }

    public void stopTimer() {
        if (!this.paused) {
            long currTime = System.currentTimeMillis();
            this.ticksElapsed = (int)((long)this.ticksElapsed + (currTime - this.lastPause));
        }
        this.paused = true;
    }

    public void resumeTimer() {
        LogInfo.logs("currTicks=" + this.ticksElapsed);
        this.lastPause = System.currentTimeMillis();
        this.paused = false;
    }

    public double totalSeconds() {
        return (double)this.ticksElapsed / 1000.0;
    }

    public double totalMinutes() {
        return this.totalSeconds() / 60.0;
    }

    public long getTicks() {
        return this.ticksElapsed;
    }
}

