/*
 * Decompiled with CFR 0.152.
 */
package times;

import Jama.Matrix;
import fig.basic.Pair;
import goblin.Taxon;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import nuts.io.IO;
import nuts.util.Arbre;
import pty.UnrootedTree;
import times.RateState;
import times.State;
import times.TimeState;

public class TreeState
implements State {
    private HashMap<Set<String>, String> cladesMap;
    private HashMap<String, Arbre<String>> arbreMap;
    private HashMap<String, Double> branchLengths;
    private Arbre<String> ar;
    private TimeState timeState;
    private RateState rateState;
    public static double alpha = 0.05;

    public TimeState getTimeState() {
        return this.timeState;
    }

    public RateState getRateState() {
        return this.rateState;
    }

    @Override
    public double getLogDensity() {
        double logd = this.jacobian();
        return logd += this.timeState.getLogDensity() + this.rateState.getLogDensity();
    }

    private double jacobian() {
        int n = this.ar.nLeaves();
        n = n - 1 + (2 * n - 2);
        Matrix m = new Matrix(n, n);
        HashMap<String, Integer> time2index = new HashMap<String, Integer>();
        HashMap<String, Integer> edge2index = new HashMap<String, Integer>();
        int index = 0;
        for (Arbre<String> a : this.ar.nodes()) {
            if (a.isLeaf()) continue;
            time2index.put(a.getContents(), index++);
        }
        for (String s : this.branchLengths.keySet()) {
            edge2index.put(s, index++);
        }
        for (String s : this.branchLengths.keySet()) {
            int i;
            double r = this.rateState.getRate(s);
            double v = this.branchLengths.get(s);
            Arbre<String> a = this.arbreMap.get(s);
            if (time2index.containsKey(s)) {
                i = (Integer)time2index.get(s);
                m.set(i, i, 1.0);
                int j = (Integer)edge2index.get(s);
                m.set(i, j, -1.0 / r);
                for (Arbre<String> l : a.getChildren()) {
                    j = (Integer)edge2index.get(l.getContents());
                    m.set(i, j, 1.0 / r);
                }
            }
            i = (Integer)edge2index.get(s);
            m.set(i, i, -v / r);
        }
        return Math.abs(m.det());
    }

    public void setTreeState(HashMap<String, Double> times, ArrayList<String> order) {
        this.timeState.setTimes(times);
        this.timeState.setOrder(order);
        HashMap<String, Double> ratesMap = new HashMap<String, Double>();
        for (String s : this.branchLengths.keySet()) {
            Arbre<String> as = this.arbreMap.get(s);
            if (as.isRoot()) continue;
            String parent = as.getParent().getContents();
            double t1 = this.timeState.getTime(s);
            double t2 = this.timeState.getTime(parent);
            double v = this.branchLengths.get(s);
            double rate = (t2 - t1) / v;
            ratesMap.put(s, rate);
        }
        this.rateState.setRates(ratesMap);
    }

    public void readNewick(String treeFile, Set<Taxon> inGroup) {
        this.cladesMap = new HashMap();
        this.arbreMap = new HashMap();
        try {
            UnrootedTree nonClockTree = UnrootedTree.fromNewick(new File(treeFile));
            Set<Taxon> outGroup = nonClockTree.leavesSet();
            outGroup.removeAll(inGroup);
            Arbre<Taxon> ar = Arbre.tree2Arbre(nonClockTree.toTree(outGroup.iterator().next()));
            Arbre<Taxon> truncatedAr = Arbre.lowestCommonAncestor(ar, inGroup).copy();
            Taxon outgroup = new Taxon("outgroup");
            Taxon root = new Taxon("root");
            Arbre<Taxon> newAr = Arbre.arbre(new Taxon("root"));
            newAr.addLeaves(truncatedAr.copy());
            newAr.addLeaves(Arbre.arbre(outgroup));
            Arbre<String> arOfString = Arbre.arbreToArbreOfStrings(newAr);
            this.ar = arOfString;
            Map<Arbre<String>, Set<String>> leavesMap = Arbre.leavesMap(arOfString);
            for (Arbre<String> a : leavesMap.keySet()) {
                String string = a.getContents();
                this.cladesMap.put(leavesMap.get(a), string);
                this.arbreMap.put(string, a);
            }
            HashMap<Taxon, Double> tmpbranchLengths = new HashMap<Taxon, Double>();
            for (Arbre<Taxon> arbre : truncatedAr.nodes()) {
                if (arbre.isRoot()) continue;
                Arbre<Taxon> parent = arbre.getParent();
                try {
                    double branchLength = nonClockTree.branchLength(arbre.getContents(), parent.getContents());
                    tmpbranchLengths.put(arbre.getContents(), branchLength);
                }
                catch (Exception e) {
                    System.out.println(arbre.getContents() + " " + parent.getContents());
                    throw new RuntimeException(e);
                }
            }
            tmpbranchLengths.put(truncatedAr.root().getContents(), 1.0);
            tmpbranchLengths.put(outgroup, 1.0);
            this.branchLengths = new HashMap();
            for (Taxon taxon : tmpbranchLengths.keySet()) {
                this.branchLengths.put(taxon.toString(), (Double)tmpbranchLengths.get(taxon));
            }
            System.out.println(newAr.deepToString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Set<Taxon> readInGroup(String inGroupFile) {
        HashSet<Taxon> keys = new HashSet<Taxon>();
        Iterator<String> iterator = IO.i(inGroupFile).iterator();
        if (iterator.hasNext()) {
            String line = iterator.next();
            StringTokenizer tok = new StringTokenizer(line, ",");
            while (tok.hasMoreTokens()) {
                keys.add(new Taxon(tok.nextToken()));
            }
        }
        return keys;
    }

    public TreeState(String treeFile, String timesFile, String ratesFile, String ingroupFile) {
        Set<Taxon> inGroup = this.readInGroup(ingroupFile);
        this.readNewick(treeFile, inGroup);
        this.timeState = new TimeState(this.ar, this.cladesMap, this.arbreMap, timesFile);
        this.rateState = new RateState(this.ar, this.cladesMap, this.arbreMap, ratesFile);
    }

    public TreeState(Arbre<String> ar, HashMap<Set<String>, String> cladesMap, HashMap<String, Arbre<String>> arbreMap, TimeState timeState, RateState rateState) {
        this.ar = ar;
        this.cladesMap = cladesMap;
        this.arbreMap = arbreMap;
        this.timeState = timeState;
        this.rateState = rateState;
    }

    public TreeState copy() {
        return new TreeState(this.ar, this.cladesMap, this.arbreMap, this.timeState, this.rateState);
    }

    public void init(Random rand) {
        this.timeState.init(rand);
    }

    public void setTimeState(TimeState ts) {
        this.timeState = ts;
    }

    @Override
    public Pair<State, Double> propose(Random rand) {
        TimeState proposedTimeState;
        double t = rand.nextDouble();
        TimeState currentTimeState = this.getTimeState();
        if (t < alpha) {
            proposedTimeState = currentTimeState.copy();
            proposedTimeState.setOrder(proposedTimeState.resampleOrder(rand));
            proposedTimeState.setTimes(proposedTimeState.resampleAllTimes(rand));
        } else {
            proposedTimeState = currentTimeState.copy();
            List<String> internalNodes = proposedTimeState.getOrder();
            int choice = rand.nextInt(internalNodes.size());
            String s = internalNodes.get(choice);
            proposedTimeState.setTimes(proposedTimeState.resampleTime(s, rand));
        }
        double logqratio = TimeState.logTransitionProbability(proposedTimeState, currentTimeState) - TimeState.logTransitionProbability(currentTimeState, proposedTimeState);
        TreeState proposedState = this.copy();
        proposedState.setTimeState(proposedTimeState);
        return new Pair<State, Double>(proposedState, logqratio);
    }

    public String toString() {
        return this.timeState.toString();
    }
}

