@if "%DEBUG%" == "" @echo off
@rem ##########################################################################
@rem
@rem  main startup script for Windows
@rem
@rem ##########################################################################

@rem Set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" setlocal

set DIRNAME=%~dp0
if "%DIRNAME%" == "" set DIRNAME=.
set APP_BASE_NAME=%~n0
set APP_HOME=%DIRNAME%..

@rem Add default JVM options here. You can also use JAVA_OPTS and MAIN_OPTS to pass JVM options to this script.
set DEFAULT_JVM_OPTS=

@rem Find java.exe
if defined JAVA_HOME goto findJavaFromJavaHome

set JAVA_EXE=java.exe
%JAVA_EXE% -version >NUL 2>&1
if "%ERRORLEVEL%" == "0" goto init

echo.
echo ERROR: JAVA_HOME is not set and no 'java' command could be found in your PATH.
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:findJavaFromJavaHome
set JAVA_HOME=%JAVA_HOME:"=%
set JAVA_EXE=%JAVA_HOME%/bin/java.exe

if exist "%JAVA_EXE%" goto init

echo.
echo ERROR: JAVA_HOME is set to an invalid directory: %JAVA_HOME%
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:init
@rem Get command-line arguments, handling Windows variants

if not "%OS%" == "Windows_NT" goto win9xME_args

:win9xME_args
@rem Slurp the command line arguments.
set CMD_LINE_ARGS=
set _SKIP=2

:win9xME_args_slurp
if "x%~1" == "x" goto execute

set CMD_LINE_ARGS=%*

:execute
@rem Setup the command line

set CLASSPATH=%APP_HOME%\lib\phylosmcsampler.jar;%APP_HOME%\lib\guava-19.0.jar;%APP_HOME%\lib\junit-4.12.jar;%APP_HOME%\lib\binc-1.2.1.jar;%APP_HOME%\lib\briefj-2.4.15.jar;%APP_HOME%\lib\commons-lang3-3.4.jar;%APP_HOME%\lib\gson-2.7.jar;%APP_HOME%\lib\org.eclipse.xtend.lib-2.9.2.jar;%APP_HOME%\lib\sfu-legacy-1.0.0.jar;%APP_HOME%\lib\hamcrest-core-1.3.jar;%APP_HOME%\lib\opencsv-2.3.jar;%APP_HOME%\lib\org.eclipse.jgit-3.7.0.201502260915-r.jar;%APP_HOME%\lib\commons-math3-3.4.1.jar;%APP_HOME%\lib\sqlite-jdbc-3.8.7.jar;%APP_HOME%\lib\commons-io-2.4.jar;%APP_HOME%\lib\slf4j-simple-1.6.1.jar;%APP_HOME%\lib\org.eclipse.xtext.xbase.lib-2.9.2.jar;%APP_HOME%\lib\org.eclipse.xtend.lib.macro-2.9.2.jar;%APP_HOME%\lib\jblas-1.2.3.jar;%APP_HOME%\lib\commons-cli-1.0.jar;%APP_HOME%\lib\forester-1.005.jar;%APP_HOME%\lib\jama-1.0.3.jar;%APP_HOME%\lib\jsci-1.2.jar;%APP_HOME%\lib\javax.servlet-api-3.1.0.jar;%APP_HOME%\lib\lucene-core-3.3.0.jar;%APP_HOME%\lib\commons-math-2.2.jar;%APP_HOME%\lib\mvel2-2.2.4.Final.jar;%APP_HOME%\lib\commons-lang-1.0.jar;%APP_HOME%\lib\lpsolve-2003-11-03.jar;%APP_HOME%\lib\mathml-dom-java-2.0.jar;%APP_HOME%\lib\xercesImpl-2.8.1.jar;%APP_HOME%\lib\xml-apis-1.3.03.jar;%APP_HOME%\lib\tutorialj-2.0.4.jar;%APP_HOME%\lib\jcommander-1.47.jar;%APP_HOME%\lib\spoon-core-4.0.0.jar;%APP_HOME%\lib\ecj-4.4.jar;%APP_HOME%\lib\jsap-2.1.jar;%APP_HOME%\lib\log4j-1.2.17.jar;%APP_HOME%\lib\jsch-0.1.50.jar;%APP_HOME%\lib\JavaEWAH-0.7.9.jar;%APP_HOME%\lib\httpclient-4.1.3.jar;%APP_HOME%\lib\slf4j-api-1.7.2.jar;%APP_HOME%\lib\httpcore-4.1.4.jar;%APP_HOME%\lib\commons-codec-1.4.jar;%APP_HOME%\lib\commons-logging-1.1.1.jar

@rem Execute main
"%JAVA_EXE%" %DEFAULT_JVM_OPTS% %JAVA_OPTS% %MAIN_OPTS%  -classpath "%CLASSPATH%" phylosmcsampler.Main %CMD_LINE_ARGS%

:end
@rem End local scope for the variables with windows NT shell
if "%ERRORLEVEL%"=="0" goto mainEnd

:fail
rem Set variable MAIN_EXIT_CONSOLE if you need the _script_ return code instead of
rem the _cmd.exe /c_ return code!
if  not "" == "%MAIN_EXIT_CONSOLE%" exit 1
exit /b 1

:mainEnd
if "%OS%"=="Windows_NT" endlocal

:omega
