/*
 * Decompiled with CFR 0.152.
 */
package comm;

import comm.EMCCommException;
import comm.Message;
import fig.basic.LogInfo;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.List;

public class ServerMessenger {
    private HashMap<Integer, InetAddress> nodes = new HashMap();
    private ServerSocket serverSocket;
    private int port;
    private int M;

    public ServerMessenger(int M, int port) {
        this.port = port;
        this.M = M;
    }

    public boolean initConnections() throws IOException, ClassNotFoundException {
        this.serverSocket = new ServerSocket(this.port);
        int count = 1;
        while (count < this.M) {
            Socket socket = this.serverSocket.accept();
            InetAddress node = socket.getInetAddress();
            LogInfo.logs("Connection request arrived from: " + node.getHostAddress());
            ObjectInputStream ois = new ObjectInputStream(socket.getInputStream());
            Message msg = null;
            while ((msg = (Message)ois.readObject()) == null || msg.message != 1) {
            }
            LogInfo.logs("Ready message received from nodeId=" + msg.senderId);
            ++count;
            Integer key = new Integer(msg.senderId);
            if (!this.nodes.containsKey(key)) {
                LogInfo.logs("This is the first request from this host, so add to the map");
                this.nodes.put(key, node);
            }
            ois.close();
            socket.close();
        }
        return count == this.M;
    }

    public Message[] listenForWeights(List<Double> serverWeights) throws IOException, ClassNotFoundException, EMCCommException {
        Message[] messages = new Message[this.M];
        for (int count = 1; count < this.M; ++count) {
            Socket socket = this.serverSocket.accept();
            ObjectInputStream ois = new ObjectInputStream(socket.getInputStream());
            Message msg = null;
            while ((msg = (Message)ois.readObject()) == null) {
            }
            if (msg.message == 3) {
                LogInfo.logs("Weight message received from nodeId=" + msg.senderId);
                messages[msg.senderId.intValue()] = msg;
            } else {
                throw new EMCCommException("Expecting weight messages but received " + msg.message);
            }
            ois.close();
            socket.close();
        }
        messages[0] = new Message(0, 3, serverWeights);
        return messages;
    }

    public void broadcast(Message msg) throws IOException {
        LogInfo.logs("broadcast weights to other machines");
        for (InetAddress node : this.nodes.values()) {
            LogInfo.logs("broadcast to " + node.getHostAddress());
            Socket socket = new Socket(node.getHostAddress(), this.port);
            ObjectOutputStream oos = new ObjectOutputStream(socket.getOutputStream());
            oos.writeObject(msg);
            oos.flush();
            oos.close();
            socket.close();
        }
    }

    public void close() {
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {
            LogInfo.logs(e);
        }
    }
}

