/*
 * Decompiled with CFR 0.152.
 */
package conifer.evol;

import conifer.Phylogeny;
import conifer.data.AlignedData;
import conifer.data.PhylogeneticData;
import conifer.data.TaxonDatum;
import conifer.evol.CalculatorOptions;
import conifer.evol.EvolutionaryOptions;
import conifer.evol.EvolutionaryParameters;
import conifer.evol.SimpleSubstitutionLikelihoodModel;
import java.util.Random;
import ma.AffineGapAlignmentSampler;
import ma.MSAPoset;
import ma.MultiAlignment;
import ma.SequenceType;
import nuts.util.Arbre;
import nuts.util.Tree;
import pty.RootedTree;
import pty.smc.models.LikelihoodModelCalculator;

public class TKF91Model
implements EvolutionaryParameters {
    final SimpleSubstitutionLikelihoodModel subModel;
    final Random generateRandom;
    final double expectedLength;
    final double changeIntensity;

    public String toString() {
        return "TKF91(expLen=" + this.expectedLength + ",intens=" + this.changeIntensity + ")";
    }

    public TKF91Model(EvolutionaryOptions options) {
        this.subModel = new SimpleSubstitutionLikelihoodModel(options);
        this.expectedLength = options.tkfParam1;
        this.changeIntensity = options.tkfParam2;
        this.generateRandom = options.rand;
    }

    @Override
    public PhylogeneticData generate(Phylogeny p) {
        RootedTree tree = p.getRooted();
        double mu = 0.002 * this.changeIntensity;
        double lam = 0.098 * this.changeIntensity;
        AffineGapAlignmentSampler.TKFParams params = new AffineGapAlignmentSampler.TKFParams(mu, lam, this.subModel.rateMatrix, this.subModel.sequenceType.getEncodings());
        Tree<String> convertedTree = Arbre.arbre2Tree(Arbre.arbreToArbreOfStrings(tree.topology()));
        AffineGapAlignmentSampler.TKFGenerator tkfGenerator = new AffineGapAlignmentSampler.TKFGenerator(params, this.generateRandom, convertedTree, tree.branchLengths());
        MSAPoset msa = MSAPoset.fromMultiAlignmentObject(MultiAlignment.inducedMultiAlignment(tkfGenerator.generate((int)this.expectedLength)));
        return new PhylogeneticData(p, new AlignedData(msa, SequenceType.RNA), msa, this);
    }

    @Override
    public LikelihoodModelCalculator createModelCalculator(CalculatorOptions calcOptions, TaxonDatum leafDatum) {
        throw new RuntimeException();
    }
}

